import { HttpClient, HttpHeaders } from '@angular/common/http';
import { Injectable } from '@angular/core';
import { expand, map, Observable, reduce } from 'rxjs';
import { environment } from 'src/environments/environment';
import { EmployeeModel } from '../model/employee.model';
import { AlertModel } from '../model/alert.model';
import { PageModel } from '../model/page.model';
@Injectable({
  providedIn: 'root'
})
export class EmployeeService {
  baseUrlapi = "/employee"
  constructor(private http: HttpClient) {
  }
  getPageList(page: string, size: string): Observable<PageModel> {
    return this.http.get<PageModel>(this.baseUrlapi + "/profile/create-short?page=" + page + "&size=" + size)
  }
  getPageListAll(): Observable<EmployeeModel[]> {
    return this.http.get<PageModel>(`${this.baseUrlapi}/profile/create-short?page=0&size=100`).pipe(
      expand(response =>
        !response.last
          ? this.http.get<PageModel>(`${this.baseUrlapi}/profile/create-short?page=${response.pageable.pageNumber + 1}&size=100`)
          : []
      ),
      map(response => response.content),
      reduce((acc: EmployeeModel[], data) => [...acc, ...data], [])
    );
  }

  getList(): Observable<EmployeeModel[]> {
    return this.http.get<EmployeeModel[]>(this.baseUrlapi + "/profile/create-short/lists")
  }
  getById(employeeId: string): Observable<EmployeeModel> {
    return this.http.get<EmployeeModel>(this.baseUrlapi + "/profile?employeeId=" + employeeId)
  }
  getWorking(): Observable<EmployeeModel> {
    return this.http.get<EmployeeModel>(this.baseUrlapi + "/working/mini")
  }
  getWorkingById(employeeId?: string): Observable<EmployeeModel> {
    return this.http.get<EmployeeModel>(this.baseUrlapi + "/working/mini" + (employeeId ? "?employeeid=" + employeeId : ''))
  }
  getProfile(): Observable<EmployeeModel> {
    return this.http.get<EmployeeModel>(this.baseUrlapi + "/profile")
  }
  add(body: EmployeeModel): Observable<AlertModel> {
    return this.http.post<AlertModel>(this.baseUrlapi + '/profile-create', body)
  }
  update(body: EmployeeModel): Observable<AlertModel> {
    return this.http.post<AlertModel>(this.baseUrlapi + '/profile-update', body)
  }
  delete(body: EmployeeModel[]): Observable<AlertModel> {
    const options = {
      headers: new HttpHeaders({
        "Content-Type": "application/json",
      }),
      body: body
    };
    return this.http.delete<AlertModel>(this.baseUrlapi + "/profile-delete", options)
  }
  getProfileMini(): Observable<EmployeeModel> {
    return this.http.get<EmployeeModel>(this.baseUrlapi + "/profile/mini")
  }
}
