import { HttpClient } from '@angular/common/http';
import { Injectable } from '@angular/core';
import { Observable } from 'rxjs';
import { environment } from 'src/environments/environment';
import { AlertModel } from '../model/alert.model';
import { AppraisalCompentencyModel, AppraisalCompentencyModel2 } from '../model/appraisal-competency.model';
import { AppraisalSubordinateModel } from '../model/appraisal-subordinate.model';
import { AppraisalPmsFormModel } from '../model/appraisal-pms-form.model';
import { AppraisalPmsModel } from '../model/appraisal-pms.model';
import { CompetencyModel } from '../model/competency.model';
@Injectable({
  providedIn: 'root'
})
export class AppraisalService {
  api = "/appraisal"
  urlApi = environment.baseUrl + this.api
  constructor(private http: HttpClient) {
  }
  getCompentencyAll(apsassessy: string, bossId?: string): Observable<CompetencyModel[]> {
    return this.http.get<CompetencyModel[]>(this.urlApi + "/competencyAll/emp?apsassessy=" + apsassessy + (bossId ? "&bossId=" + bossId : ''))
  }
  postCompentencyAll(body: CompetencyModel): Observable<AlertModel> {
    return this.http.post<AlertModel>(this.urlApi + "/competencyAll/emp", body)
  }
  getFormCompentencyById(evaluationRoundId: string, apsassessy: string, typeId: string): Observable<AppraisalCompentencyModel2> {
    return this.http.get<AppraisalCompentencyModel2>(this.urlApi + "/competency/" + evaluationRoundId + "/" + apsassessy + "/" + typeId)
  }
  getCompetencyList(employeeId?: string): Observable<AppraisalCompentencyModel[]> {
    return this.http.get<AppraisalCompentencyModel[]>(this.urlApi + "/competency/emp" + (employeeId ? "?employeeid=" + employeeId : ''))
  }
  postCompetency(body: AppraisalCompentencyModel2): Observable<AlertModel> {
    return this.http.post<AlertModel>(this.urlApi + "/competency", body)
  }
  getBossList(): Observable<AppraisalSubordinateModel[]> {
    return this.http.get<AppraisalSubordinateModel[]>(this.urlApi + "/boss/emp")
  }

  getPmsList(): Observable<AppraisalPmsModel[]> {
    return this.http.get<AppraisalPmsModel[]>(this.urlApi + "/pms/emp")
  }
  getFormPmsById(evaluationRoundId: string, apsassessy: string): Observable<AppraisalPmsFormModel> {
    return this.http.get<AppraisalPmsFormModel>(this.urlApi + "/pms/" + evaluationRoundId + "/" + apsassessy)
  }
  postPms(body: AppraisalPmsFormModel): Observable<AlertModel> {
    return this.http.post<AlertModel>(this.urlApi + "/pms", body)
  }

  postBossApproveAll(body: {
    masFromEvaluationRoundId: string,
    employeeId: string[]
  }): Observable<AlertModel> {
    return this.http.post<AlertModel>(this.urlApi + "/approveAll", body)
  }
}