import { CompetencyGradeModel, MyCompetencyGradeModel } from "./competency-grades.model"

export interface CompetencyGroupGradeModel {
  groupGradeId: string
  companyId: string
  edesc: string
  tdesc: string
  competencyGrades: CompetencyGradeModel[]
}

export class MyCompetencyGroupGradeModel implements CompetencyGroupGradeModel {
  groupGradeId: string
  companyId: string
  edesc: string
  tdesc: string
  competencyGrades: CompetencyGradeModel[]
  constructor(data: Partial<CompetencyGroupGradeModel>) {
    this.groupGradeId = data.groupGradeId || ""
    this.companyId = data.companyId || ""
    this.tdesc = data.tdesc || ""
    this.edesc = data.edesc || ""
    this.competencyGrades = data.competencyGrades?.map(x => (new MyCompetencyGradeModel(x))) || []
  }
}

