import { Component, EventEmitter, Input, Output } from '@angular/core';
import { DomSanitizer, SafeHtml } from '@angular/platform-browser';
interface SubModule {
  title: SafeHtml;
  route?: string;
  file?: string;
}
@Component({
  selector: 'app-employee-self-service',
  templateUrl: './employee-self-service.component.html',
  styleUrls: ['./employee-self-service.component.scss']
})
export class EmployeeSelfServiceComponent {
  // ▶︎ ภาพทางซ้าย (ปรับ path ตามจริง)
  heroImg = 'assets/illustrations/performance.svg';

  // ▶︎ เมนูย่อย (ฝั่งขวา)
  modules: SubModule[] = [
    { title: this.sanitizer.bypassSecurityTrustHtml('ประเมิน<p>Competency & PMS'), route: '/ess/self-evaluation' },
    // { title: this.sanitizer.bypassSecurityTrustHtml('Job Description<p>รายละเอียดของงาน'), file: '2._JD.pdf' },
    { title: this.sanitizer.bypassSecurityTrustHtml('Job Description<p>รายละเอียดของงาน'), route: '/ess/job-description' },
    { title: this.sanitizer.bypassSecurityTrustHtml('Gap Analysis<p>การวิเคราะห์ Gap'), file: '3._Gap_analysis.pdf' },
    { title: this.sanitizer.bypassSecurityTrustHtml('Profile<p>ข้อมูลพนักงาน'), route: '/ess/profile' },
    { title: this.sanitizer.bypassSecurityTrustHtml('Skill Map<p>ทักษะที่จำเป็นสำหรับแต่ละตำแหน่งงาน'), file: '5._skill_map.pdf' },
    { title: this.sanitizer.bypassSecurityTrustHtml('CDR : Competency Dictionary Roadmap<p>หลักสูตรฝึกอบรมตามระบบสมรรถนะ'), file: '6._CDR.pdf' },
    { title: this.sanitizer.bypassSecurityTrustHtml('IDP : Individual Development Plan<p>แผนพัฒนารายบุคคล'), route: '/ess/self-evaluation/IDP' },
    { title: this.sanitizer.bypassSecurityTrustHtml('Competency Base Pay<p>ค่าความสามารถพิเศษ') }
  ];
  constructor(private sanitizer: DomSanitizer) {

  }
  openReport(file: string) {
    const url = 'assets/reports/' + file;
    window.open(url, '_blank');
  }

}


