import { HttpClient, HttpHeaders } from '@angular/common/http';
import { Injectable } from '@angular/core';
import { Observable } from 'rxjs';
import { environment } from 'src/environments/environment';
import { Bu2Model } from '../model/bu2.model';
import { AlertModel } from '../model/alert.model';
@Injectable({
  providedIn: 'root'
})
export class Bu2Service {
  api = "/bu2"
  urlApi = environment.baseUrl + this.api
  constructor(private http: HttpClient) {
  }
  getList(): Observable<Bu2Model[]> {
    return this.http.get<Bu2Model[]>(this.urlApi + "/lists")
  }
  getListByParent(bu1id: string): Observable<Bu2Model[]> {
    return this.http.get<Bu2Model[]>(environment.baseUrl + "/bu1/parent/" + bu1id)
  }
  getById(bu2id: string): Observable<Bu2Model> {
    return this.http.get<Bu2Model>(this.urlApi + "/" + bu2id)
  }
  post(body: Bu2Model): Observable<AlertModel> {
    return this.http.post<AlertModel>(this.urlApi, body)
  }
  delete(body: Bu2Model[]): Observable<AlertModel> {
    const options = {
      headers: new HttpHeaders({
        "Content-Type": "application/json",
      }),
      body: body
    };
    return this.http.delete<AlertModel>(this.urlApi, options)
  }
}
