export interface CompanyModel {
    companyId: string
    tdesc: string
    edesc: string
    companyGroup: string
    amphur: string
    tvillage: string
    troomno: string
    tfloor: string
    taddr: string
    tmoo: string
    tsoi: string
    troad: string
    tdistrict: string
    evillage: string
    eroomno: string
    efloor: string
    eaddr: string
    emoo: string
    esoi: string
    eroad: string
    edistrict: string
    zipcode: string
    tel: string
    fax: string
    website: string
    insType: string
    companyType: string
    noOfEmployee: number
    empDaily: number
    noOfDaily: number
    empMonthly: number
    noOfMonthly: number
    empOther: number
    noOfOther: number
    officeWorkTime: string
    probation: number
    descOther: string
    noOfBranch: number
    payCash: number
    payCheque: number
    payBank: number
    payOther: number
    compensationTax: string
    companyAbb: string
    brandTdesc: string
    brandEdesc: string
    logo: string
    addressText: string
    contactText: string
}


export class MyCompanyModel implements CompanyModel {
    companyId: string
    tdesc: string
    edesc: string
    companyGroup: string
    amphur: string
    tvillage: string
    troomno: string
    tfloor: string
    taddr: string
    tmoo: string
    tsoi: string
    troad: string
    tdistrict: string
    evillage: string
    eroomno: string
    efloor: string
    eaddr: string
    emoo: string
    esoi: string
    eroad: string
    edistrict: string
    zipcode: string
    tel: string
    fax: string
    website: string
    insType: string
    companyType: string
    noOfEmployee: number
    empDaily: number
    noOfDaily: number
    empMonthly: number
    noOfMonthly: number
    empOther: number
    noOfOther: number
    officeWorkTime: string
    probation: number
    descOther: string
    noOfBranch: number
    payCash: number
    payCheque: number
    payBank: number
    payOther: number
    compensationTax: string
    companyAbb: string
    brandTdesc: string
    brandEdesc: string
    logo: string
    addressText: string
    contactText: string
    constructor(data: Partial<CompanyModel>) {
        this.companyId = data.companyId || ""
        this.tdesc = data.tdesc || ""
        this.edesc = data.edesc || ""
        this.companyGroup = data.companyGroup || ""
        this.amphur = data.amphur || ""
        this.tvillage = data.tvillage || ""
        this.troomno = data.troomno || ""
        this.tfloor = data.tfloor || ""
        this.taddr = data.taddr || ""
        this.tmoo = data.tmoo || ""
        this.tsoi = data.tsoi || ""
        this.troad = data.troad || ""
        this.tdistrict = data.tdistrict || ""
        this.evillage = data.evillage || ""
        this.eroomno = data.eroomno || ""
        this.efloor = data.efloor || ""
        this.eaddr = data.eaddr || ""
        this.emoo = data.emoo || ""
        this.esoi = data.esoi || ""
        this.eroad = data.eroad || ""
        this.edistrict = data.edistrict || ""
        this.zipcode = data.zipcode || ""
        this.tel = data.tel || ""
        this.fax = data.fax || ""
        this.website = data.website || ""
        this.insType = data.insType || ""
        this.companyType = data.companyType || ""
        this.noOfEmployee = data.noOfEmployee ?? 0
        this.empDaily = data.empDaily ?? 0
        this.noOfDaily = data.noOfDaily ?? 0
        this.empMonthly = data.empMonthly ?? 0
        this.noOfMonthly = data.noOfMonthly ?? 0
        this.empOther = data.empOther ?? 0
        this.noOfOther = data.noOfOther ?? 0
        this.officeWorkTime = data.officeWorkTime || ""
        this.probation = data.probation ?? 0
        this.descOther = data.descOther || ""
        this.noOfBranch = data.noOfBranch ?? 0
        this.payCash = data.payCash ?? 0
        this.payCheque = data.payCheque ?? 0
        this.payBank = data.payBank ?? 0
        this.payOther = data.payOther ?? 0
        this.compensationTax = data.compensationTax || ""
        this.companyAbb = data.companyAbb || ""
        this.brandTdesc = data.brandTdesc || ""
        this.brandEdesc = data.brandEdesc || ""
        this.logo = data.logo || ""
        this.addressText = data.addressText || ""
        this.contactText = data.contactText || ""
    }
}

