import { AppraisalFormModel, MyAppraisalFormModel } from "./appraisal-form.model"
import { EmployeeModel, MyEmployeeModel } from "./employee.model"
import { EvaluationCycleModel, MyEvaluationCycleModel } from "./evaluation-cycle.model"
import { JobcodeModel, MyJobcodeModel } from "./jobcode.model"
import { MyPLModel, PLModel } from "./pl.model"

export interface AppraisalModel {
    personalLevel: PLModel
    jd: JobcodeModel
    masfromEvaluationRound: EvaluationCycleModel
    companyId: string
    active: boolean
    statusEmp: boolean
    apsassessy: EmployeeModel
    apsapprove1: EmployeeModel
    apsapprove2: EmployeeModel
    apsapprove3: EmployeeModel
    apsapprove4: EmployeeModel
    apsapprove5: EmployeeModel
    masfromEvaluationAssessment1: AppraisalFormModel[]
}
export class MyAppraisalModel implements AppraisalModel {
    personalLevel: PLModel
    jd: JobcodeModel
    masfromEvaluationRound: EvaluationCycleModel
    companyId: string
    active: boolean
    statusEmp: boolean
    apsassessy: EmployeeModel
    apsapprove1: EmployeeModel
    apsapprove2: EmployeeModel
    apsapprove3: EmployeeModel
    apsapprove4: EmployeeModel
    apsapprove5: EmployeeModel
    masfromEvaluationAssessment1: AppraisalFormModel[]
    constructor(data?: Partial<AppraisalModel>) {
        this.personalLevel = new MyPLModel(data?.personalLevel)
        this.jd = new MyJobcodeModel(data?.jd)
        this.masfromEvaluationRound = new MyEvaluationCycleModel(data?.masfromEvaluationRound)
        this.companyId = data?.companyId || ""
        this.active = data?.active ?? false
        this.statusEmp = data?.statusEmp ?? false
        this.apsassessy = new MyEmployeeModel(data?.apsassessy)
        this.apsapprove1 = new MyEmployeeModel(data?.apsapprove1)
        this.apsapprove2 = new MyEmployeeModel(data?.apsapprove2)
        this.apsapprove3 = new MyEmployeeModel(data?.apsapprove3)
        this.apsapprove4 = new MyEmployeeModel(data?.apsapprove4)
        this.apsapprove5 = new MyEmployeeModel(data?.apsapprove5)
        this.masfromEvaluationAssessment1 = data?.masfromEvaluationAssessment1?.map(x => new MyAppraisalFormModel(x)) || []

    }
}

