export interface AppraisalKpiSettingEmpModel {
  apsassessy: ApsassessyModel
  apsyear: string
  currentTopic: TopicModel[]
  defendTopic: TopicModel[]
  jd: string
  pmsEvaluationRoundId: string
  statusAll: StatusAllModel
  confirmBy: string
}
export class MyAppraisalKpiSettingEmpModel implements AppraisalKpiSettingEmpModel {
  apsassessy: ApsassessyModel
  apsyear: string
  currentTopic: TopicModel[]
  defendTopic: TopicModel[]
  jd: string
  pmsEvaluationRoundId: string
  statusAll: StatusAllModel
  confirmBy: string
  constructor(data?: Partial<AppraisalKpiSettingEmpModel>) {
    this.apsassessy = new MyApsassessyModel(data?.apsassessy)
    this.apsyear = data?.apsyear || ''
    this.currentTopic = (data?.currentTopic || []).map(e => new MyTopicModel(e))
    this.defendTopic = (data?.defendTopic || []).map(e => new MyTopicModel(e))
    this.jd = data?.jd || ''
    this.pmsEvaluationRoundId = data?.pmsEvaluationRoundId || ''
    this.statusAll = new MyStatusAllModel(data?.statusAll)
    this.confirmBy = data?.confirmBy || ''
  }
}

export interface StatusAllModel {
  code: string
  edesc: string
  tdesc: string
}

export class MyStatusAllModel implements StatusAllModel {
  code: string
  edesc: string
  tdesc: string
  constructor(data?: Partial<StatusAllModel>) {
    this.code = data?.code || ''
    this.edesc = data?.edesc || ''
    this.tdesc = data?.tdesc || ''
  }
}

// ---------------- GradeDetailModel ----------------
export interface GradeDetailModel {
  companyId: string
  countAverage: string
  countEmployee: string
  countScore: string
  edesc: string
  gradeDetail: string
  gradeId: string
  gradeMaxScore: number
  gradeMinScore: number
  tdesc: string
  weight: number
}
export class MyGradeDetailModel implements GradeDetailModel {
  companyId: string
  countAverage: string
  countEmployee: string
  countScore: string
  edesc: string
  gradeDetail: string
  gradeId: string
  gradeMaxScore: number
  gradeMinScore: number
  tdesc: string
  weight: number
  constructor(data?: Partial<GradeDetailModel>) {
    this.companyId = data?.companyId || ''
    this.countAverage = data?.countAverage || ''
    this.countEmployee = data?.countEmployee || ''
    this.countScore = data?.countScore || ''
    this.edesc = data?.edesc || ''
    this.gradeDetail = data?.gradeDetail || ''
    this.gradeId = data?.gradeId || ''
    this.gradeMaxScore = data?.gradeMaxScore ?? 0
    this.gradeMinScore = data?.gradeMinScore ?? 0
    this.tdesc = data?.tdesc || ''
    this.weight = data?.weight ?? 0
  }
}

// ---------------- GradeModel ----------------
// Note: Grade2 is considered same as Grade -> we use GradeModel
export interface GradeModel {
  countAverage: string
  countEmployee: string
  countScore: string
  gradeDetail: GradeDetailModel[]
}
export class MyGradeModel implements GradeModel {
  countAverage: string
  countEmployee: string
  countScore: string
  gradeDetail: GradeDetailModel[]
  constructor(data?: Partial<GradeModel>) {
    this.countAverage = data?.countAverage || ''
    this.countEmployee = data?.countEmployee || ''
    this.countScore = data?.countScore || ''
    this.gradeDetail = (data?.gradeDetail || []).map(e => new MyGradeDetailModel(e))
  }
}

// ---------------- Bu1Model ----------------
export interface Bu1Model {
  bu1id: string
  companyId: string
  edesc: string
  grade: GradeModel
  tdesc: string
}
export class MyBu1Model implements Bu1Model {
  bu1id: string
  companyId: string
  edesc: string
  grade: GradeModel
  tdesc: string
  constructor(data?: Partial<Bu1Model>) {
    this.bu1id = data?.bu1id || ''
    this.companyId = data?.companyId || ''
    this.edesc = data?.edesc || ''
    this.grade = new MyGradeModel(data?.grade)
    this.tdesc = data?.tdesc || ''
  }
}

// ---------------- Bu2Model ----------------
export interface Bu2Model {
  bu2id: string
  companyId: string
  edesc: string
  parent: string
  tdesc: string
}
export class MyBu2Model implements Bu2Model {
  bu2id: string
  companyId: string
  edesc: string
  parent: string
  tdesc: string
  constructor(data?: Partial<Bu2Model>) {
    this.bu2id = data?.bu2id || ''
    this.companyId = data?.companyId || ''
    this.edesc = data?.edesc || ''
    this.parent = data?.parent || ''
    this.tdesc = data?.tdesc || ''
  }
}

// ---------------- Bu3Model ----------------
export interface Bu3Model {
  bu3id: string
  companyId: string
  edesc: string
  parent: string
  tdesc: string
}
export class MyBu3Model implements Bu3Model {
  bu3id: string
  companyId: string
  edesc: string
  parent: string
  tdesc: string
  constructor(data?: Partial<Bu3Model>) {
    this.bu3id = data?.bu3id || ''
    this.companyId = data?.companyId || ''
    this.edesc = data?.edesc || ''
    this.parent = data?.parent || ''
    this.tdesc = data?.tdesc || ''
  }
}

// ---------------- Bu4Model ----------------
export interface Bu4Model {
  bu4id: string
  companyId: string
  edesc: string
  parent: string
  tdesc: string
}
export class MyBu4Model implements Bu4Model {
  bu4id: string
  companyId: string
  edesc: string
  parent: string
  tdesc: string
  constructor(data?: Partial<Bu4Model>) {
    this.bu4id = data?.bu4id || ''
    this.companyId = data?.companyId || ''
    this.edesc = data?.edesc || ''
    this.parent = data?.parent || ''
    this.tdesc = data?.tdesc || ''
  }
}

// ---------------- Bu5Model ----------------
export interface Bu5Model {
  bu5id: string
  companyId: string
  edesc: string
  parent: string
  tdesc: string
}
export class MyBu5Model implements Bu5Model {
  bu5id: string
  companyId: string
  edesc: string
  parent: string
  tdesc: string
  constructor(data?: Partial<Bu5Model>) {
    this.bu5id = data?.bu5id || ''
    this.companyId = data?.companyId || ''
    this.edesc = data?.edesc || ''
    this.parent = data?.parent || ''
    this.tdesc = data?.tdesc || ''
  }
}

// ---------------- JobModel ----------------
export interface JobModel {
  companyId: string
  edesc: string
  jobCodeId: string
  statusCom: boolean
  statusPms: boolean
  tdesc: string
}
export class MyJobModel implements JobModel {
  companyId: string
  edesc: string
  jobCodeId: string
  statusCom: boolean
  statusPms: boolean
  tdesc: string
  constructor(data?: Partial<JobModel>) {
    this.companyId = data?.companyId || ''
    this.edesc = data?.edesc || ''
    this.jobCodeId = data?.jobCodeId || ''
    this.statusCom = data?.statusCom ?? false
    this.statusPms = data?.statusPms ?? false
    this.tdesc = data?.tdesc || ''
  }
}

// ---------------- PmsTypeModel ----------------
export interface PmsTypeModel {
  companyId: string
  edesc: string
  pmsTypeId: string
  shortName: string
  tdesc: string
  weight: number
}
export class MyPmsTypeModel implements PmsTypeModel {
  companyId: string
  edesc: string
  pmsTypeId: string
  shortName: string
  tdesc: string
  weight: number
  constructor(data?: Partial<PmsTypeModel>) {
    this.companyId = data?.companyId || ''
    this.edesc = data?.edesc || ''
    this.pmsTypeId = data?.pmsTypeId || ''
    this.shortName = data?.shortName || ''
    this.tdesc = data?.tdesc || ''
    this.weight = data?.weight ?? 0
  }
}

export interface TopicModel {
  approveTopicStatus: number
  companyId: string
  completionDate: string
  createStatusBy: string
  detailUnit: string
  edesc: string
  indicatorsDetail: string
  jl: string
  lineNo: number
  performanceGoalsDetail: string
  pmsTopicId: string
  pmsType: PmsTypeModel | null
  scoreTopicExpectation: number
  scoreTopicExpectationBoss: number
  statusApprove: string
  targetAdetail: string
  targetBdetail: string
  targetCdetail: string
  targetDdetail: string
  targetEdetail: string
  tdesc: string
  weight: number
}
export class MyTopicModel implements TopicModel {
  approveTopicStatus: number
  companyId: string
  completionDate: string
  createStatusBy: string
  detailUnit: string
  edesc: string
  indicatorsDetail: string
  jl: string
  lineNo: number
  performanceGoalsDetail: string
  pmsTopicId: string
  pmsType: PmsTypeModel | null
  scoreTopicExpectation: number
  scoreTopicExpectationBoss: number
  statusApprove: string
  targetAdetail: string
  targetBdetail: string
  targetCdetail: string
  targetDdetail: string
  targetEdetail: string
  tdesc: string
  weight: number
  constructor(data?: Partial<TopicModel>) {
    this.approveTopicStatus = data?.approveTopicStatus ?? 0
    this.companyId = data?.companyId || ''
    this.completionDate = data?.completionDate || ''
    this.createStatusBy = data?.createStatusBy || ''
    this.detailUnit = data?.detailUnit || ''
    this.edesc = data?.edesc || ''
    this.indicatorsDetail = data?.indicatorsDetail || ''
    this.jl = data?.jl || ''
    this.lineNo = data?.lineNo ?? 0
    this.performanceGoalsDetail = data?.performanceGoalsDetail || ''
    this.pmsTopicId = data?.pmsTopicId || ''
    this.pmsType = data?.pmsType ? new MyPmsTypeModel(data?.pmsType) : null
    this.scoreTopicExpectation = data?.scoreTopicExpectation ?? 0
    this.scoreTopicExpectationBoss = data?.scoreTopicExpectationBoss ?? 0
    this.statusApprove = data?.statusApprove || ''
    this.targetAdetail = data?.targetAdetail || ''
    this.targetBdetail = data?.targetBdetail || ''
    this.targetCdetail = data?.targetCdetail || ''
    this.targetDdetail = data?.targetDdetail || ''
    this.targetEdetail = data?.targetEdetail || ''
    this.tdesc = data?.tdesc || ''
    this.weight = data?.weight ?? 0
  }
}



// ---------------- PositionModel ----------------
export interface PositionModel {
  companyId: string
  consolidate: string
  edesc: string
  positionId: string
  shortName: string
  tdesc: string
}
export class MyPositionModel implements PositionModel {
  companyId: string
  consolidate: string
  edesc: string
  positionId: string
  shortName: string
  tdesc: string
  constructor(data?: Partial<PositionModel>) {
    this.companyId = data?.companyId || ''
    this.consolidate = data?.consolidate || ''
    this.edesc = data?.edesc || ''
    this.positionId = data?.positionId || ''
    this.shortName = data?.shortName || ''
    this.tdesc = data?.tdesc || ''
  }
}

// ---------------- PrefixModel ----------------
export interface PrefixModel {
  edesc: string
  prefixId: string
  tdesc: string
}
export class MyPrefixModel implements PrefixModel {
  edesc: string
  prefixId: string
  tdesc: string
  constructor(data?: Partial<PrefixModel>) {
    this.edesc = data?.edesc || ''
    this.prefixId = data?.prefixId || ''
    this.tdesc = data?.tdesc || ''
  }
}

// ---------------- StatusModel ----------------
export interface StatusModel {
  edesc: string
  statusCode: string
  statusType: string
  tdesc: string
}
export class MyStatusModel implements StatusModel {
  edesc: string
  statusCode: string
  statusType: string
  tdesc: string
  constructor(data?: Partial<StatusModel>) {
    this.edesc = data?.edesc || ''
    this.statusCode = data?.statusCode || ''
    this.statusType = data?.statusType || ''
    this.tdesc = data?.tdesc || ''
  }
}

// ---------------- Time0Model ----------------
export interface Time0Model {
  edesc: string
  hourD: number
  stickTm: string
  tdesc: string
  time0id: string
}
export class MyTime0Model implements Time0Model {
  edesc: string
  hourD: number
  stickTm: string
  tdesc: string
  time0id: string
  constructor(data?: Partial<Time0Model>) {
    this.edesc = data?.edesc || ''
    this.hourD = data?.hourD ?? 0
    this.stickTm = data?.stickTm || ''
    this.tdesc = data?.tdesc || ''
    this.time0id = data?.time0id || ''
  }
}

// ---------------- PlModel ----------------
export interface PlModel {
  companyId: string
  edesc: string
  grade: GradeModel
  plId: string
  tdesc: string
}
export class MyPlModel implements PlModel {
  companyId: string
  edesc: string
  grade: GradeModel
  plId: string
  tdesc: string
  constructor(data?: Partial<PlModel>) {
    this.companyId = data?.companyId || ''
    this.edesc = data?.edesc || ''
    this.grade = new MyGradeModel(data?.grade)
    this.plId = data?.plId || ''
    this.tdesc = data?.tdesc || ''
  }
}

// ---------------- ApsassessyModel (root) ----------------
export interface ApsassessyModel {
  bossId: string
  bu1: Bu1Model
  bu2: Bu2Model
  bu3: Bu3Model
  bu4: Bu4Model
  bu5: Bu5Model
  efname: string
  elname: string
  employeeId: string
  endWorkDate: string
  engFullName: string
  fname: string
  job: JobModel
  lname: string
  picture: string
  pl: PlModel
  position: PositionModel
  prefix: PrefixModel
  resignDate: string
  startDate: string
  status: StatusModel
  thFullName: string
  time0: Time0Model
}
export class MyApsassessyModel implements ApsassessyModel {
  bossId: string
  bu1: Bu1Model
  bu2: Bu2Model
  bu3: Bu3Model
  bu4: Bu4Model
  bu5: Bu5Model
  efname: string
  elname: string
  employeeId: string
  endWorkDate: string
  engFullName: string
  fname: string
  job: JobModel
  lname: string
  picture: string
  pl: PlModel
  position: PositionModel
  prefix: PrefixModel
  resignDate: string
  startDate: string
  status: StatusModel
  thFullName: string
  time0: Time0Model

  constructor(data?: Partial<ApsassessyModel>) {
    this.bossId = data?.bossId || ''
    this.bu1 = new MyBu1Model(data?.bu1)
    this.bu2 = new MyBu2Model(data?.bu2)
    this.bu3 = new MyBu3Model(data?.bu3)
    this.bu4 = new MyBu4Model(data?.bu4)
    this.bu5 = new MyBu5Model(data?.bu5)
    this.efname = data?.efname || ''
    this.elname = data?.elname || ''
    this.employeeId = data?.employeeId || ''
    this.endWorkDate = data?.endWorkDate || ''
    this.engFullName = data?.engFullName || ''
    this.fname = data?.fname || ''
    this.job = new MyJobModel(data?.job)
    this.lname = data?.lname || ''
    this.picture = data?.picture || ''
    this.pl = new MyPlModel(data?.pl)
    this.position = new MyPositionModel(data?.position)
    this.prefix = new MyPrefixModel(data?.prefix)
    this.resignDate = data?.resignDate || ''
    this.startDate = data?.startDate || ''
    this.status = new MyStatusModel(data?.status)
    this.thFullName = data?.thFullName || ''
    this.time0 = new MyTime0Model(data?.time0)
  }
}
