import { Component } from '@angular/core';
import { EChartsOption } from 'echarts';

interface Row {
  level: string;
  A: number; B: number; C: number; D: number; E: number;
  sum: number;
}
@Component({
  selector: 'app-report-pms-2',
  templateUrl: './report-pms-2.component.html',
  styleUrls: ['./report-pms-2.component.scss']
})
export class ReportPms2Component {

  /* ===== Chart ===== */
  chartOpt: EChartsOption = {
    grid: { top: 18, left: 50, right: 8, bottom: 26 },
    tooltip: { trigger: 'axis' },
    xAxis: {
      type: 'category',
      data: ['A', 'B', 'C', 'D', 'E'],
      axisLabel: { fontFamily: 'Inter', fontWeight: 600 }
    },
    yAxis: { type: 'value', splitLine: { show: false } },
    series: [
      {
        name: 'จำนวนพนักงาน',
        type: 'bar',
        data: [1, 7, 5, 0, 0],
        itemStyle: { color: '#1d4ed8', borderRadius: [4, 4, 0, 0] },
        barWidth: '45%'
      },
      {
        name: 'เทรนด์',
        type: 'line',
        data: [1, 7, 5, 0, 0],
        smooth: true,
        lineStyle: { width: 3, color: '#3b82f6' },
        symbolSize: 8,
        itemStyle: { color: '#3b82f6' }
      }
    ]
  };

  /* ===== Table data (ตัวอย่าง) ===== */
  rows: Row[] = [
    { level: 'S3', A: 1, B: 25, C: 3, D: 75, E: 0, sum: 4 },
    { level: 'S2', A: 1, B: 25, C: 3, D: 75, E: 0, sum: 4 },
    { level: 'S1', A: 1, B: 0, C: 1, D: 50, E: 0, sum: 2 },
    { level: 'E4', A: 0, B: 0, C: 0, D: 0, E: 0, sum: 0 },
    // … (ข้อมูลจริงต่อได้)
  ];

  get grand(): Row {
    const g: Row = { level: 'Total', A: 0, B: 0, C: 0, D: 0, E: 0, sum: 0 };
    this.rows.forEach(r => {
      g.A += r.A; g.B += r.B; g.C += r.C; g.D += r.D; g.E += r.E; g.sum += r.sum;
    });
    return g;
  }
}
