import { ViewportScroller } from '@angular/common';
import { ChangeDetectorRef, Component } from '@angular/core';
import { EmployeeModel, MyEmployeeModel } from 'src/app/shared/model/employee.model';
import { MyStatusModel, StatusModel } from 'src/app/shared/model/status.model';
import { EmpStatusService } from 'src/app/shared/services/emp-status.service';
import { EmployeeService } from 'src/app/shared/services/employee.service';
import { FileService } from 'src/app/shared/services/file.service';
import { environment } from 'src/environments/environment';

@Component({
  selector: 'app-ess-profile',
  templateUrl: './ess-profile.component.html',
  styleUrls: ['./ess-profile.component.scss'],
})
export class EssProfileComponent {
  employee: { loading: boolean, data: EmployeeModel } = { loading: false, data: new MyEmployeeModel() }
  empStatus: { loading: boolean, dataList: StatusModel[] } = { loading: false, dataList: [] }
  constructor(
    private employeeService: EmployeeService,
    private empStatusService: EmpStatusService,
    private cdr: ChangeDetectorRef,
    private viewScroller: ViewportScroller,
    private fileService: FileService
  ) {
  }
  ngOnInit(): void {
    this.viewScroller.scrollToPosition([0, 0]);
    this.getEmpStatusList()
    this.getProfileMini()
  }
  getProfileMini() {
    this.employee.loading = true
    this.employeeService.getProfileMini().subscribe({
      next: response => {
        this.employee.data = new MyEmployeeModel(response);
        this.employee.loading = false;
        this.cdr.detectChanges()
      },
      error: error => {
        this.employee.loading = false;
        this.cdr.detectChanges()
      }
    });
  }
  getEmpStatusList() {
    this.empStatus.loading = false
    this.empStatusService.getList().subscribe({
      next: response => {
        this.empStatus.dataList = response.map((x: any) => new MyStatusModel(x))
        this.empStatus.loading = false
        this.cdr.detectChanges()
      }, error: error => {
        this.empStatus.loading = false
        this.cdr.detectChanges()
      }
    })
  }
  findEmpStatus(text: string) {
    return this.empStatus.dataList.find(e => e.statusCode == text)?.tdesc || ''
  }
  reverseDate(text: string) {
    return text.split('-').reverse().join('-')
  }

  getImg(text: string) {
    return this.fileService.getImg(text)
  }

  onImageError(event: Event) {
    const imgElement = event.target as HTMLImageElement;
    imgElement.src = './assets/img/users/defaultperson.jpg';
  }
}
