import { HttpClient, HttpHeaders } from '@angular/common/http';
import { Injectable } from '@angular/core';
import { Observable } from 'rxjs';
import { environment } from 'src/environments/environment';
import { AlertModel } from '../model/alert.model';
import { EvaluationCycleModel } from '../model/evaluation-cycle.model';

@Injectable({
    providedIn: 'root'
})
export class PmsEvaluationCycleService {
    api = "/pms-evaluation-round"
    urlApi = environment.baseUrl + this.api
    constructor(private http: HttpClient) {
    }
    getList(): Observable<EvaluationCycleModel[]> {
        return this.http.get<EvaluationCycleModel[]>(this.urlApi + "/lists")
    }
    getById(evaluationRoundId: string): Observable<EvaluationCycleModel> {
        return this.http.get<EvaluationCycleModel>(this.urlApi + "/" + evaluationRoundId)
    }
    getApsassessy(evaluationRoundId: string,apsassessy:string): Observable<EvaluationCycleModel> {
        return this.http.get<EvaluationCycleModel>(this.urlApi + "/" + evaluationRoundId+"/"+apsassessy)
    }
    post(body: EvaluationCycleModel): Observable<AlertModel> {
        return this.http.post<AlertModel>(this.urlApi, body)
      }
    delete(body: EvaluationCycleModel | EvaluationCycleModel[]): Observable<AlertModel> {
        const options = {
          headers: new HttpHeaders({
            "Content-Type": "application/json",
          }),
          body: body
        };
    return this.http.delete<AlertModel>(this.urlApi, options)
    }
}
