import { HttpClient, HttpHeaders } from '@angular/common/http';
import { Injectable } from '@angular/core';
import { Observable } from 'rxjs';
import { environment } from 'src/environments/environment';
import { JobCodeModel } from '../model/job-code.model';
import { AlertModel } from '../model/alert.model';

@Injectable({
    providedIn: 'root'
})
export class JobCodeService {
    api = "/jobcode"
    urlApi = environment.baseUrl + this.api
    constructor(private http: HttpClient) {
    }
    getList(): Observable<JobCodeModel[]> {
        return this.http.get<JobCodeModel[]>(this.urlApi + "/lists")
    }
    getById(jobcodeId: string): Observable<JobCodeModel> {
        return this.http.get<JobCodeModel>(this.urlApi + "/" + jobcodeId)
    }
    post(body: JobCodeModel): Observable<AlertModel> {
        return this.http.post<AlertModel>(this.urlApi, body)
    }
    delete(body: JobCodeModel | JobCodeModel[]): Observable<AlertModel> {
        const options = {
            headers: new HttpHeaders({
                "Content-Type": "application/json",
            }),
            body: body
        };
        return this.http.delete<AlertModel>(this.urlApi, options)
    }
}
