import { CompetencyGradeModel, MyCompetencyGradeModel } from "./competency-grades.model"

export interface PmsGroupGradeModel {
  groupGradeId: string
  companyId: string
  edesc: string
  tdesc: string
  pmsGrade: CompetencyGradeModel[]
}

export class MyPmsGroupGradeModel implements PmsGroupGradeModel {
  groupGradeId: string
  companyId: string
  edesc: string
  tdesc: string
  pmsGrade: CompetencyGradeModel[]
  constructor(data: Partial<PmsGroupGradeModel>) {
    this.groupGradeId = data.groupGradeId || ""
    this.companyId = data.companyId || ""
    this.tdesc = data.tdesc || ""
    this.edesc = data.edesc || ""
    this.pmsGrade = data.pmsGrade?.map(x => (new MyCompetencyGradeModel(x))) || []
  }
}

