import { environment } from "src/environments/environment"

export interface ExcelPortalModel {
    approveBy: string
    approveDate: string
    approveTime: string
    dbSupport: string
    downloadDate: string
    downloadTime: string
    dwTime: number
    engDesc: string
    engName: string
    excelId: string
    fileData: string
    fileType: string
    group: ExcelPortalGroupModel
    isDataGrid: number
    isPivot: number
    link1: string
    referId: string
    remark: string
    tags: ExcelPortalTagsModel[]
    thDesc: string
    thName: string
    thumbnail: string
    uploadBy: string
    uploadDate: string
    uploadTime: string
}
export class MyExcelPortalModel implements ExcelPortalModel {
    approveBy: string
    approveDate: string
    approveTime: string
    dbSupport: string
    downloadDate: string
    downloadTime: string
    dwTime: number
    engDesc: string
    engName: string
    excelId: string
    fileData: string
    fileType: string
    group: ExcelPortalGroupModel
    isDataGrid: number
    isPivot: number
    link1: string
    referId: string
    remark: string
    tags: ExcelPortalTagsModel[]
    thDesc: string
    thName: string
    thumbnail: string
    uploadBy: string
    uploadDate: string
    uploadTime: string
    constructor(data?: Partial<ExcelPortalModel>) {
        this.approveBy = data?.approveBy || ''
        this.approveDate = data?.approveDate || ''
        this.approveTime = data?.approveTime || ''
        this.dbSupport = data?.dbSupport || ''
        this.downloadDate = data?.downloadDate || ''
        this.downloadTime = data?.downloadTime || ''
        this.dwTime = data?.dwTime ?? 0
        this.engDesc = data?.engDesc || ''
        this.engName = data?.engName || ''
        this.excelId = data?.excelId || ''
        this.fileData = data?.fileData || ''
        this.fileType = data?.fileType || ''
        this.group = new MyExcelPortalGroupModel(data?.group || {})
        this.isDataGrid = data?.isDataGrid ?? 0
        this.isPivot = data?.isPivot ?? 0
        this.link1 = data?.link1 || ''
        this.referId = data?.referId || ''
        this.remark = data?.remark || ''
        this.tags = data?.tags?.map(e => new MyExcelPortalTagsModel(e)) || []
        this.thDesc = data?.thDesc || ''
        this.thName = data?.thName || ''
        this.thumbnail = data?.thumbnail || ''
        this.uploadBy = data?.uploadBy || ''
        this.uploadDate = data?.uploadDate || ''
        this.uploadTime = data?.uploadTime || ''
    }
    getImg() {
        return this.thumbnail ? environment.baseUrl + "files/image/" + this.thumbnail : ''
    }
}

export interface ExcelPortalGroupModel {
    engName: string
    groupId: string
    groupType: number
    thName: string
}
export class MyExcelPortalGroupModel implements ExcelPortalGroupModel {
    engName: string
    groupId: string
    groupType: number
    thName: string
    constructor(data?: Partial<ExcelPortalGroupModel>) {
        this.engName = data?.engName || ''
        this.groupId = data?.groupId || ''
        this.groupType = data?.groupType ?? 0
        this.thName = data?.thName || ''
    }
}
export interface ExcelPortalTagsModel {
    display: string
    value: string
}
export class MyExcelPortalTagsModel implements ExcelPortalTagsModel {
    display: string
    value: string
    constructor(data?: Partial<ExcelPortalTagsModel>) {
        this.display = data?.display || ''
        this.value = data?.value || ''
    }
}