import { DOCUMENT } from '@angular/common';
import { Component, ElementRef, Inject, Renderer2 } from '@angular/core';

@Component({
  selector: 'app-basic',
  templateUrl: './basic.component.html',
  styleUrls: ['./basic.component.scss']
})
export class BasicComponent {
  constructor(@Inject(DOCUMENT) private document: Document,private elementRef: ElementRef,
  private renderer: Renderer2,private el: ElementRef) {}

  ngOnInit(): void {
    this.renderer.addClass(this.document.body, "authentication-page");
       const html : any = this.elementRef.nativeElement.ownerDocument.documentElement;
    html.setAttribute('data-header-styles', 'light');
    html.removeAttribute('data-nav-layout','vertical');
    html.classList.add('h-full', 'light');
      if (localStorage.getItem('synto-header-mode') == 'dark') {
        const html: any = this.elementRef.nativeElement.ownerDocument.documentElement;
        html.classList.add('h-full', 'dark');
      }
  }

  ngOnDestroy(): void {
     if (localStorage.getItem('synto-header-mode') == 'dark') {
       const html: any = this.elementRef.nativeElement.ownerDocument.documentElement;
       html.classList.remove('h-full', 'dark');
     }
}
}
