import { NgModule } from '@angular/core';
import { CommonModule } from '@angular/common';

import { AuthenticationRoutingModule } from './authentication-routing.module';
import { LoginPageComponent } from './login-page/login-page.component';
import { RegisterPageComponent } from './register-page/register-page.component';
import { FormsModule, ReactiveFormsModule } from '@angular/forms';
import { AngularFireAuthModule } from '@angular/fire/compat/auth';
import { HTTP_INTERCEPTORS, provideHttpClient, withInterceptorsFromDi } from '@angular/common/http';
import { AuthService } from '../shared/services/auth.service';
import { HttpRequestInterceptor } from '../shared/services/http-request.interceptor';

@NgModule({ declarations: [LoginPageComponent, RegisterPageComponent], imports: [CommonModule,
        AuthenticationRoutingModule,
        AngularFireAuthModule,
        FormsModule,
        ReactiveFormsModule], providers: [AuthService, {
            provide: HTTP_INTERCEPTORS,
            useClass: HttpRequestInterceptor,
            multi: true,
        }, provideHttpClient(withInterceptorsFromDi()),] })
export class AuthenticationModule { }
