import { HttpClient, HttpHeaders } from '@angular/common/http';
import { Injectable } from '@angular/core';
import { Observable } from 'rxjs';
import { environment } from 'src/environments/environment';
import { AlertModel } from '../model/alert.model';
import { PmsSettingAssessmentModel } from '../model/pms-setting-assessment.model';

@Injectable({
  providedIn: 'root'
})
export class PmsSettingAssessmentService {
  api = "/pms-setting-assessment"
  urlApi = environment.baseUrl + this.api
  constructor(private http: HttpClient) {
  }
  get(): Observable<PmsSettingAssessmentModel> {
    return this.http.get<PmsSettingAssessmentModel>(this.urlApi)
  }
  post(body: PmsSettingAssessmentModel): Observable<AlertModel> {
    return this.http.post<AlertModel>(this.urlApi, body)
  }
}
