import { HttpClient, HttpHeaders } from '@angular/common/http';
import { Injectable } from '@angular/core';
import { Observable } from 'rxjs';
import { environment } from 'src/environments/environment';
import { PLModel } from '../model/pl.model';
import { AlertModel } from '../model/alert.model';
import { PmsGroupAssessmentModel } from '../model/pms-group-assessment.model';
@Injectable({
  providedIn: 'root'
})
export class PmsGroupAssessmentService {
  api = "/pms-group-assessment"
  urlApi = environment.baseUrl + this.api
  constructor(private http: HttpClient) {
  }
  getBy_plId(plId: string): Observable<PmsGroupAssessmentModel> {
    return this.http.get<PmsGroupAssessmentModel>(this.urlApi + "/" + plId)
  }
  getList(): Observable<PmsGroupAssessmentModel[]> {
    return this.http.get<PmsGroupAssessmentModel[]>(this.urlApi + "/lists")
  }
  post(body: PmsGroupAssessmentModel): Observable<AlertModel> {
    return this.http.post<AlertModel>(this.urlApi, body)
  }
  delete(body: PmsGroupAssessmentModel | PmsGroupAssessmentModel[]): Observable<AlertModel> {
    const options = {
      headers: new HttpHeaders({
        "Content-Type": "application/json",
      }),
      body: body
    };
    return this.http.delete<AlertModel>(this.urlApi, options)
  }
}