import { HttpClient, HttpHeaders } from '@angular/common/http';
import { Injectable } from '@angular/core';
import { Observable } from 'rxjs';
import { environment } from 'src/environments/environment';
import { AlertModel } from '../model/alert.model';
import { IndicatorsCoursesModel } from '../model/indicators-courses.model';
@Injectable({
  providedIn: 'root'
})
export class IndicatorsCoursesService {
  api = "/indicators-courses"
  urlApi = environment.baseUrl + this.api
  constructor(private http: HttpClient) {
  }
  getList(): Observable<IndicatorsCoursesModel[]> {
    return this.http.get<IndicatorsCoursesModel[]>(this.urlApi + "/lists/indicators-courses")
  }
  getById(competencyIndicatorsId: string): Observable<IndicatorsCoursesModel> {
    return this.http.get<IndicatorsCoursesModel>(this.urlApi + "/" + competencyIndicatorsId)
  }
  post(body: IndicatorsCoursesModel): Observable<AlertModel> {
    return this.http.post<AlertModel>(this.urlApi, body)
  }
  delete(body: IndicatorsCoursesModel): Observable<AlertModel> {
    const options = {
      headers: new HttpHeaders({
        "Content-Type": "application/json",
      }),
      body: body
    };
    return this.http.delete<AlertModel>(this.urlApi, options)
  }
}
