import { HttpClient, HttpHeaders } from '@angular/common/http';
import { Injectable } from '@angular/core';
import { Observable } from 'rxjs';
import { environment } from 'src/environments/environment';
import { AlertModel } from '../model/alert.model';
import { IdpDevelopmentModel } from '../model/idp-development.model';

@Injectable({
    providedIn: 'root'
})
export class IdpDevelopmentService {
    api = "/idp"
    urlApi = environment.baseUrl + this.api
    constructor(private http: HttpClient) {
    }
    getList(): Observable<IdpDevelopmentModel> {
        return this.http.get<IdpDevelopmentModel>(this.urlApi + "/lists")
    }
    // getById(companyId: string): Observable<IdpDevelopmentModel> {
    //     return this.http.get<IdpDevelopmentModel>(this.urlApi + "/" + companyId)
    // }
    post(body: IdpDevelopmentModel): Observable<AlertModel> {
        return this.http.post<AlertModel>(this.urlApi, body)
      }
    delete(body: IdpDevelopmentModel | IdpDevelopmentModel[]): Observable<AlertModel> {
        const options = {
          headers: new HttpHeaders({
            "Content-Type": "application/json",
          }),
          body: body
        };
    return this.http.delete<AlertModel>(this.urlApi, options)
    }
}
