import { HttpClient, HttpHeaders } from '@angular/common/http';
import { Injectable } from '@angular/core';
import { Observable } from 'rxjs';
import { environment } from 'src/environments/environment';
import { AlertModel } from '../model/alert.model';
import { CompetencyGroupGradeModel } from '../model/competency-group-grade.model';
@Injectable({
  providedIn: 'root'
})
export class CompetencyGroupGradeService {
  api = "/competency-group-grade"
  urlApi = environment.baseUrl + this.api
  constructor(private http: HttpClient) {
  }
  getById(plId: string): Observable<CompetencyGroupGradeModel> {
    return this.http.get<CompetencyGroupGradeModel>(this.urlApi + "/" + plId)
  }
  getList(): Observable<CompetencyGroupGradeModel[]> {
    return this.http.get<CompetencyGroupGradeModel[]>(this.urlApi + "/lists")
  }
  post(body: CompetencyGroupGradeModel): Observable<AlertModel> {
    return this.http.post<AlertModel>(this.urlApi, body)
  }
  delete(body: CompetencyGroupGradeModel | CompetencyGroupGradeModel[]): Observable<AlertModel> {
    const options = {
      headers: new HttpHeaders({
        "Content-Type": "application/json",
      }),
      body: body
    };
    return this.http.delete<AlertModel>(this.urlApi, options)
  }
}