import { HttpClient, HttpHeaders } from '@angular/common/http';
import { Injectable } from '@angular/core';
import { Observable } from 'rxjs';
import { environment } from 'src/environments/environment';
import { AlertModel } from '../model/alert.model';
import { ComEvaluationFactorsModel } from '../model/com-ealuation-factors.model';

@Injectable({
  providedIn: 'root'
})
export class ComEvaluationFactorsService {
  api = "/com-evaluation-factors"
  urlApi = environment.baseUrl + this.api
  constructor(private http: HttpClient) {
  }
  getList(): Observable<ComEvaluationFactorsModel[]> {
    return this.http.get<ComEvaluationFactorsModel[]>(this.urlApi + "/lists")
  }
  post(body: ComEvaluationFactorsModel[]): Observable<AlertModel> {
    return this.http.post<AlertModel>(this.urlApi, body)
  }
}