import { JobcodeModel, MyJobcodeModel } from "./jobcode.model";
import { PLModel, MyPLModel } from "./pl.model";
import { MyStatusCodeModel, StatusCodeModel } from "./status-code.model";
import { MyStatusFromModel, StatusFromModel } from "./status-from.model";

export interface PmsMasfromEvaluationModel {
    pmsEvaluationRoundId: string
    companyId: string
    tdesc: string
    edesc: string
    apsyear: string
    apsPeriodStart: string
    apsPeriodEnd: string
    statusCode: StatusCodeModel
    statusFrom: StatusFromModel
    active: number
    personalLevel: PLModel[]
    jd: JobcodeModel[]
}

export class MyPmsMasfromEvaluationModel implements PmsMasfromEvaluationModel {
    pmsEvaluationRoundId: string
    companyId: string
    tdesc: string
    edesc: string
    apsyear: string
    apsPeriodStart: string
    apsPeriodEnd: string
    statusCode: StatusCodeModel
    statusFrom: StatusFromModel
    active: number
    personalLevel: PLModel[]
    jd: JobcodeModel[]
    constructor(data?: Partial<PmsMasfromEvaluationModel>) {
        this.pmsEvaluationRoundId = data?.pmsEvaluationRoundId || "";
        this.companyId = data?.companyId || "";
        this.tdesc = data?.tdesc || "";
        this.edesc = data?.edesc || "";
        this.apsyear = data?.apsyear || "";
        this.apsPeriodStart = data?.apsPeriodStart || "";
        this.apsPeriodEnd = data?.apsPeriodEnd || "";
        this.active = data?.active || 0
        this.statusCode = new MyStatusCodeModel(data?.statusCode)
        this.statusFrom = new MyStatusFromModel(data?.statusFrom || {})
        this.personalLevel = data?.personalLevel?.map(x => new MyPLModel(x)) || []
        this.jd = data?.jd?.map(x => new MyJobcodeModel(x)) || []

    }
}
