import { MySortModel, SortModel } from "./sort.model"

export interface PageableModel {
    sort: SortModel
    offset: number
    pageNumber: number
    pageSize: number
    paged: boolean
    unpaged: boolean
}

export class MyPageableModel implements PageableModel {
    sort: SortModel
    offset: number
    pageNumber: number
    pageSize: number
    paged: boolean
    unpaged: boolean
    constructor(data: Partial<PageableModel>) {
        this.sort = new MySortModel(data.sort || {})
        this.offset = data.offset ?? 0
        this.pageNumber = data.pageNumber ?? 0
        this.pageSize = data.pageSize ?? 0
        this.paged = data.paged || false
        this.unpaged = data.unpaged || false
    }
}

