import { BranchModel, MyBranchModel } from "./branch.model"
import { Bu1Model, MyBu1Model } from "./bu1.model"
import { Bu2Model, MyBu2Model } from "./bu2.model"
import { Bu3Model, MyBu3Model } from "./bu3.model"
import { Bu4Model, MyBu4Model } from "./bu4.model"
import { Bu5Model, MyBu5Model } from "./bu5.model"
import { Bu6Model, MyBu6Model } from "./bu6.model"
import { Bu7Model, MyBu7Model } from "./bu7.model"
import { MyPositionModel, PositionModel } from "./position.model"

export interface JobCodeModel {
    jobcodeId: string
    companyId: string
    tdesc: string
    edesc: string
    jobcodeLevel: string
    age0: number
    age1: number
    experience: string
    responsibility: string
    qualification: string
    position: PositionModel
    bu1: Bu1Model
    bu2: Bu2Model
    bu3: Bu3Model
    bu4: Bu4Model
    bu5: Bu5Model
    bu6: Bu6Model
    bu7: Bu7Model
    branch: BranchModel
    eexperience: string
    eresponsibility: string
    equalification: string
    jobObjective: string
    supervisor: string
    competencyWorkText: string
    serviceWorkText: string
    serviceWorkPercent: number
    responsibleWorkText: string
    responsibleWorkPercent: number
    specialWorkText: string
    specialWorkPercent: number
    allPositionWorkText: string
    allPositionWorkPercent: number
    otherWorkText: string
    otherWorkPercent: number
    kpiWorkText: string
    educationExperienceText: string
    cerLicensedText: string
    especiallyTrainingText: string
    otherAbilitiesText: string
    jl: JlModel
    supervisorJobCode: SupervisorJobCodeModel
    expectation: number | null
    positionInJob: PositionInJobModel[]
    createDate: string
    editDate: string
}

export class MyJobCodeModel implements JobCodeModel {
    jobcodeId: string
    companyId: string
    tdesc: string
    edesc: string
    jobcodeLevel: string
    age0: number
    age1: number
    experience: string
    responsibility: string
    qualification: string
    position: PositionModel
    bu1: Bu1Model
    bu2: Bu2Model
    bu3: Bu3Model
    bu4: Bu4Model
    bu5: Bu5Model
    bu6: Bu6Model
    bu7: Bu7Model
    branch: BranchModel
    eexperience: string
    eresponsibility: string
    equalification: string
    jobObjective: string
    supervisor: string
    competencyWorkText: string
    serviceWorkText: string
    serviceWorkPercent: number
    responsibleWorkText: string
    responsibleWorkPercent: number
    specialWorkText: string
    specialWorkPercent: number
    allPositionWorkText: string
    allPositionWorkPercent: number
    otherWorkText: string
    otherWorkPercent: number
    kpiWorkText: string
    educationExperienceText: string
    cerLicensedText: string
    especiallyTrainingText: string
    otherAbilitiesText: string
    jl: JlModel
    supervisorJobCode: SupervisorJobCodeModel
    expectation: number | null
    positionInJob: PositionInJobModel[]
    createDate: string
    editDate: string
    constructor(data: Partial<JobCodeModel>) {
        this.jobcodeId = data.jobcodeId || ""
        this.companyId = data.companyId || ""
        this.tdesc = data.tdesc || ""
        this.edesc = data.edesc || ""
        this.jobcodeLevel = data.jobcodeLevel || ""
        this.age0 = data.age0 ?? 0
        this.age1 = data.age1 ?? 0
        this.experience = data.experience || ""
        this.responsibility = data.responsibility || ""
        this.qualification = data.qualification || ""
        this.position = new MyPositionModel(data.position || {})
        this.bu1 = new MyBu1Model(data.bu1 || {})
        this.bu2 = new MyBu2Model(data.bu2 || {})
        this.bu3 = new MyBu3Model(data.bu3 || {})
        this.bu4 = new MyBu4Model(data.bu4 || {})
        this.bu5 = new MyBu5Model(data.bu5 || {})
        this.bu6 = new MyBu6Model(data.bu6 || {})
        this.bu7 = new MyBu7Model(data.bu7 || {})
        this.branch = new MyBranchModel(data.branch || {})
        this.eexperience = data.eexperience || ""
        this.eresponsibility = data.eresponsibility || ""
        this.equalification = data.equalification || ""
        this.jobObjective = data.jobObjective || ""
        this.supervisor = data.supervisor || ""
        this.competencyWorkText = data.competencyWorkText || ""
        this.serviceWorkText = data.serviceWorkText || ""
        this.serviceWorkPercent = data.serviceWorkPercent ?? 0
        this.responsibleWorkText = data.responsibleWorkText || ""
        this.responsibleWorkPercent = data.responsibleWorkPercent ?? 0
        this.specialWorkText = data.specialWorkText || ""
        this.specialWorkPercent = data.specialWorkPercent ?? 0
        this.allPositionWorkText = data.allPositionWorkText || ""
        this.allPositionWorkPercent = data.allPositionWorkPercent ?? 0
        this.otherWorkText = data.otherWorkText || ""
        this.otherWorkPercent = data.otherWorkPercent ?? 0
        this.kpiWorkText = data.kpiWorkText || ""
        this.educationExperienceText = data.educationExperienceText || ""
        this.cerLicensedText = data.cerLicensedText || ""
        this.especiallyTrainingText = data.especiallyTrainingText || ""
        this.otherAbilitiesText = data.otherAbilitiesText || ""
        this.jl = new MyJlModel(data?.jl)
        this.supervisorJobCode = new MySupervisorJobCodeModel(data?.supervisorJobCode)
        this.expectation = data?.expectation ?? null
        this.positionInJob = (data?.positionInJob || []).map(e => new MyPositionInJobModel(e))
        this.createDate = data?.createDate || ''
        this.editDate = data?.editDate || ''
    }
}



export interface PositionInJobModel {
    countPosition: number
    position: PositionModel
}

export class MyPositionInJobModel implements PositionInJobModel {
    countPosition: number
    position: PositionModel
    constructor(data?: Partial<PositionInJobModel>) {
        this.countPosition = data?.countPosition ?? 0
        this.position = new MyPositionModel(data?.position || {})
    }
}

export interface SupervisorJobCodeModel {
    jobCodeId: string
    tdesc: string
    edesc: string
    companyId: string
    statusCom: boolean
    statusPms: boolean
}

export class MySupervisorJobCodeModel implements SupervisorJobCodeModel {
    jobCodeId: string
    tdesc: string
    edesc: string
    companyId: string
    statusCom: boolean
    statusPms: boolean
    constructor(data?: Partial<SupervisorJobCodeModel>) {
        this.jobCodeId = data?.jobCodeId || ''
        this.tdesc = data?.tdesc || ''
        this.edesc = data?.edesc || ''
        this.companyId = data?.companyId || ''
        this.statusCom = data?.statusCom ?? false
        this.statusPms = data?.statusPms ?? false
    }
}

export interface JlModel {
    plId: string
    tdesc: string
    edesc: string
    companyId: string
}

export class MyJlModel implements JlModel {
    plId: string
    tdesc: string
    edesc: string
    companyId: string
    constructor(data?: Partial<JlModel>) {
        this.plId = data?.plId || ''
        this.tdesc = data?.tdesc || ''
        this.edesc = data?.edesc || ''
        this.companyId = data?.companyId || ''
    }
}
