import { JobCodeModel, MyJobCodeModel } from "./job-code.model";
import { MyPrefixModel, PrefixModel } from "./prefix.model";

export interface BossModel {
    employeeId: string
    prefix: PrefixModel
    fname: string
    lname: string
    efname: string
    elname: string
    empType: string
    empPosition: string
    job: JobCodeModel
    thFullName: string
    engFullName: string
}

export class MyBossModel implements BossModel {
    employeeId: string
    prefix: PrefixModel
    fname: string
    lname: string
    efname: string
    elname: string
    empType: string
    empPosition: string
    job: JobCodeModel
    thFullName: string
    engFullName: string
    constructor(data?: Partial<BossModel>) {
        this.employeeId = data?.employeeId || ""
        this.prefix = new MyPrefixModel(data?.prefix || {})
        this.fname = data?.fname || ""
        this.lname = data?.lname || ""
        this.efname = data?.efname || ""
        this.elname = data?.elname || ""
        this.empType = data?.empType || ""
        this.empPosition = data?.empPosition || ""
        this.job = new MyJobCodeModel(data?.job || {})
        this.thFullName = data?.thFullName || ""
        this.engFullName = data?.engFullName || ""
    }
}

