export interface AppraisalKpiSettingModel {
  apsassessy: ApsassessyModel
  pmsEvaluationRound: PmsEvaluationRoundModel
  statusApprove: StatusApproveModel
}

export class MyAppraisalKpiSettingModel implements AppraisalKpiSettingModel {
  apsassessy: ApsassessyModel
  pmsEvaluationRound: PmsEvaluationRoundModel
  statusApprove: StatusApproveModel

  constructor(data?: Partial<AppraisalKpiSettingModel>) {
    this.apsassessy = new MyApsassessyModel(data?.apsassessy)
    this.pmsEvaluationRound = new MyPmsEvaluationRoundModel(data?.pmsEvaluationRound)
    this.statusApprove = new MyStatusApproveModel(data?.statusApprove)
  }
}

export interface ApsassessyModel {
  bossId: string
  bu1: Bu1Model
  bu2: Bu2Model
  bu3: Bu3Model
  bu4: Bu4Model
  bu5: Bu5Model
  efname: string
  elname: string
  employeeId: string
  endWorkDate: string
  engFullName: string
  fname: string
  job: JobModel
  lname: string
  picture: string
  pl: PlModel
  position: PositionModel
  prefix: PrefixModel
  resignDate: string
  startDate: string
  status: StatusModel
  thFullName: string
  time0: TimeModel
}

export class MyApsassessyModel implements ApsassessyModel {
  bossId: string
  bu1: Bu1Model
  bu2: Bu2Model
  bu3: Bu3Model
  bu4: Bu4Model
  bu5: Bu5Model
  efname: string
  elname: string
  employeeId: string
  endWorkDate: string
  engFullName: string
  fname: string
  job: JobModel
  lname: string
  picture: string
  pl: PlModel
  position: PositionModel
  prefix: PrefixModel
  resignDate: string
  startDate: string
  status: StatusModel
  thFullName: string
  time0: TimeModel

  constructor(data?: Partial<ApsassessyModel>) {
    this.bossId = data?.bossId || ''
    this.bu1 = new MyBu1Model(data?.bu1)
    this.bu2 = new MyBu2Model(data?.bu2)
    this.bu3 = new MyBu3Model(data?.bu3)
    this.bu4 = new MyBu4Model(data?.bu4)
    this.bu5 = new MyBu5Model(data?.bu5)
    this.efname = data?.efname || ''
    this.elname = data?.elname || ''
    this.employeeId = data?.employeeId || ''
    this.endWorkDate = data?.endWorkDate || ''
    this.engFullName = data?.engFullName || ''
    this.fname = data?.fname || ''
    this.job = new MyJobModel(data?.job)
    this.lname = data?.lname || ''
    this.picture = data?.picture || ''
    this.pl = new MyPlModel(data?.pl)
    this.position = new MyPositionModel(data?.position)
    this.prefix = new MyPrefixModel(data?.prefix)
    this.resignDate = data?.resignDate || ''
    this.startDate = data?.startDate || ''
    this.status = new MyStatusModel(data?.status)
    this.thFullName = data?.thFullName || ''
    this.time0 = new MyTimeModel(data?.time0)
  }
}

// -------------------- BU1 --------------------
export interface Bu1Model {
  bu1id: string
  companyId: string
  edesc: string
  grade: GradeModel
  tdesc: string
}

export class MyBu1Model implements Bu1Model {
  bu1id: string
  companyId: string
  edesc: string
  grade: GradeModel
  tdesc: string
  constructor(data?: Partial<Bu1Model>) {
    this.bu1id = data?.bu1id || ''
    this.companyId = data?.companyId || ''
    this.edesc = data?.edesc || ''
    this.grade = new MyGradeModel(data?.grade)
    this.tdesc = data?.tdesc || ''
  }
}

// -------------------- GRADE --------------------
export interface GradeModel {
  countAverage: string
  countEmployee: string
  countScore: string
  gradeDetail: GradeDetailModel[]
}

export class MyGradeModel implements GradeModel {
  countAverage: string
  countEmployee: string
  countScore: string
  gradeDetail: GradeDetailModel[]
  constructor(data?: Partial<GradeModel>) {
    this.countAverage = data?.countAverage || ''
    this.countEmployee = data?.countEmployee || ''
    this.countScore = data?.countScore || ''
    this.gradeDetail = (data?.gradeDetail || []).map(e => new MyGradeDetailModel(e))
  }
}

export interface GradeDetailModel {
  companyId: string
  countAverage: string
  countEmployee: string
  countScore: string
  edesc: string
  gradeDetail: string
  gradeId: string
  gradeMaxScore: number
  gradeMinScore: number
  tdesc: string
  weight: number
}

export class MyGradeDetailModel implements GradeDetailModel {
  companyId: string
  countAverage: string
  countEmployee: string
  countScore: string
  edesc: string
  gradeDetail: string
  gradeId: string
  gradeMaxScore: number
  gradeMinScore: number
  tdesc: string
  weight: number
  constructor(data?: Partial<GradeDetailModel>) {
    this.companyId = data?.companyId || ''
    this.countAverage = data?.countAverage || ''
    this.countEmployee = data?.countEmployee || ''
    this.countScore = data?.countScore || ''
    this.edesc = data?.edesc || ''
    this.gradeDetail = data?.gradeDetail || ''
    this.gradeId = data?.gradeId || ''
    this.gradeMaxScore = data?.gradeMaxScore ?? 0
    this.gradeMinScore = data?.gradeMinScore ?? 0
    this.tdesc = data?.tdesc || ''
    this.weight = data?.weight ?? 0
  }
}

// -------------------- BU2-BU5 --------------------
export interface Bu2Model {
  bu2id: string
  companyId: string
  edesc: string
  parent: string
  tdesc: string
}
export class MyBu2Model implements Bu2Model {
  bu2id: string
  companyId: string
  edesc: string
  parent: string
  tdesc: string
  constructor(data?: Partial<Bu2Model>) {
    this.bu2id = data?.bu2id || ''
    this.companyId = data?.companyId || ''
    this.edesc = data?.edesc || ''
    this.parent = data?.parent || ''
    this.tdesc = data?.tdesc || ''
  }
}

export interface Bu3Model {
  bu3id: string
  companyId: string
  edesc: string
  parent: string
  tdesc: string
}
export class MyBu3Model implements Bu3Model {
  bu3id: string
  companyId: string
  edesc: string
  parent: string
  tdesc: string
  constructor(data?: Partial<Bu3Model>) {
    this.bu3id = data?.bu3id || ''
    this.companyId = data?.companyId || ''
    this.edesc = data?.edesc || ''
    this.parent = data?.parent || ''
    this.tdesc = data?.tdesc || ''
  }
}

export interface Bu4Model {
  bu4id: string
  companyId: string
  edesc: string
  parent: string
  tdesc: string
}
export class MyBu4Model implements Bu4Model {
  bu4id: string
  companyId: string
  edesc: string
  parent: string
  tdesc: string
  constructor(data?: Partial<Bu4Model>) {
    this.bu4id = data?.bu4id || ''
    this.companyId = data?.companyId || ''
    this.edesc = data?.edesc || ''
    this.parent = data?.parent || ''
    this.tdesc = data?.tdesc || ''
  }
}

export interface Bu5Model {
  bu5id: string
  companyId: string
  edesc: string
  parent: string
  tdesc: string
}
export class MyBu5Model implements Bu5Model {
  bu5id: string
  companyId: string
  edesc: string
  parent: string
  tdesc: string
  constructor(data?: Partial<Bu5Model>) {
    this.bu5id = data?.bu5id || ''
    this.companyId = data?.companyId || ''
    this.edesc = data?.edesc || ''
    this.parent = data?.parent || ''
    this.tdesc = data?.tdesc || ''
  }
}


// -------------------- JOB --------------------
export interface JobModel {
  companyId: string
  edesc: string
  jobCodeId: string
  statusCom: boolean
  statusPms: boolean
  tdesc: string
}

export class MyJobModel implements JobModel {
  companyId: string
  edesc: string
  jobCodeId: string
  statusCom: boolean
  statusPms: boolean
  tdesc: string
  constructor(data?: Partial<JobModel>) {
    this.companyId = data?.companyId || ''
    this.edesc = data?.edesc || ''
    this.jobCodeId = data?.jobCodeId || ''
    this.statusCom = data?.statusCom ?? false
    this.statusPms = data?.statusPms ?? false
    this.tdesc = data?.tdesc || ''
  }
}

// -------------------- PL + Grade2 --------------------
export interface PlModel {
  companyId: string
  edesc: string
  grade: Grade2Model
  plId: string
  tdesc: string
}

export class MyPlModel implements PlModel {
  companyId: string
  edesc: string
  grade: Grade2Model
  plId: string
  tdesc: string
  constructor(data?: Partial<PlModel>) {
    this.companyId = data?.companyId || ''
    this.edesc = data?.edesc || ''
    this.grade = new MyGrade2Model(data?.grade)
    this.plId = data?.plId || ''
    this.tdesc = data?.tdesc || ''
  }
}

export interface Grade2Model {
  countAverage: string
  countEmployee: string
  countScore: string
  gradeDetail: GradeDetail2Model[]
}

export class MyGrade2Model implements Grade2Model {
  countAverage: string
  countEmployee: string
  countScore: string
  gradeDetail: GradeDetail2Model[]
  constructor(data?: Partial<Grade2Model>) {
    this.countAverage = data?.countAverage || ''
    this.countEmployee = data?.countEmployee || ''
    this.countScore = data?.countScore || ''
    this.gradeDetail = (data?.gradeDetail || []).map(e => new MyGradeDetail2Model(e))
  }
}

export interface GradeDetail2Model {
  companyId: string
  countAverage: string
  countEmployee: string
  countScore: string
  edesc: string
  gradeDetail: string
  gradeId: string
  gradeMaxScore: number
  gradeMinScore: number
  tdesc: string
  weight: number
}

export class MyGradeDetail2Model implements GradeDetail2Model {
  companyId: string
  countAverage: string
  countEmployee: string
  countScore: string
  edesc: string
  gradeDetail: string
  gradeId: string
  gradeMaxScore: number
  gradeMinScore: number
  tdesc: string
  weight: number
  constructor(data?: Partial<GradeDetail2Model>) {
    this.companyId = data?.companyId || ''
    this.countAverage = data?.countAverage || ''
    this.countEmployee = data?.countEmployee || ''
    this.countScore = data?.countScore || ''
    this.edesc = data?.edesc || ''
    this.gradeDetail = data?.gradeDetail || ''
    this.gradeId = data?.gradeId || ''
    this.gradeMaxScore = data?.gradeMaxScore ?? 0
    this.gradeMinScore = data?.gradeMinScore ?? 0
    this.tdesc = data?.tdesc || ''
    this.weight = data?.weight ?? 0
  }
}

// -------------------- POSITION --------------------
export interface PositionModel {
  companyId: string
  consolidate: string
  edesc: string
  positionId: string
  shortName: string
  tdesc: string
}

export class MyPositionModel implements PositionModel {
  companyId: string
  consolidate: string
  edesc: string
  positionId: string
  shortName: string
  tdesc: string
  constructor(data?: Partial<PositionModel>) {
    this.companyId = data?.companyId || ''
    this.consolidate = data?.consolidate || ''
    this.edesc = data?.edesc || ''
    this.positionId = data?.positionId || ''
    this.shortName = data?.shortName || ''
    this.tdesc = data?.tdesc || ''
  }
}

// -------------------- PREFIX --------------------
export interface PrefixModel {
  edesc: string
  prefixId: string
  tdesc: string
}

export class MyPrefixModel implements PrefixModel {
  edesc: string
  prefixId: string
  tdesc: string
  constructor(data?: Partial<PrefixModel>) {
    this.edesc = data?.edesc || ''
    this.prefixId = data?.prefixId || ''
    this.tdesc = data?.tdesc || ''
  }
}

// -------------------- STATUS --------------------
export interface StatusModel {
  edesc: string
  statusCode: string
  statusType: string
  tdesc: string
}

export class MyStatusModel implements StatusModel {
  edesc: string
  statusCode: string
  statusType: string
  tdesc: string
  constructor(data?: Partial<StatusModel>) {
    this.edesc = data?.edesc || ''
    this.statusCode = data?.statusCode || ''
    this.statusType = data?.statusType || ''
    this.tdesc = data?.tdesc || ''
  }
}

// -------------------- TIME0 --------------------
export interface TimeModel {
  edesc: string
  hourD: number
  stickTm: string
  tdesc: string
  time0id: string
}

export class MyTimeModel implements TimeModel {
  edesc: string
  hourD: number
  stickTm: string
  tdesc: string
  time0id: string
  constructor(data?: Partial<TimeModel>) {
    this.edesc = data?.edesc || ''
    this.hourD = data?.hourD ?? 0
    this.stickTm = data?.stickTm || ''
    this.tdesc = data?.tdesc || ''
    this.time0id = data?.time0id || ''
  }
}

// -------------------- PmsEvaluationRound --------------------
export interface PmsEvaluationRoundModel {
  active: number
  apsPeriodEnd: string
  apsPeriodStart: string
  apsyear: string
  checkForm: number
  companyId: string
  edesc: string
  jd: JdModel[]
  jdId: string
  pmsEvaluationRoundId: string
  statusCode: StatusCodeModel
  statusFrom: StatusFromModel
  tdesc: string
}

export class MyPmsEvaluationRoundModel implements PmsEvaluationRoundModel {
  active: number
  apsPeriodEnd: string
  apsPeriodStart: string
  apsyear: string
  checkForm: number
  companyId: string
  edesc: string
  jd: JdModel[]
  jdId: string
  pmsEvaluationRoundId: string
  statusCode: StatusCodeModel
  statusFrom: StatusFromModel
  tdesc: string
  constructor(data?: Partial<PmsEvaluationRoundModel>) {
    this.active = data?.active ?? 0
    this.apsPeriodEnd = data?.apsPeriodEnd || ''
    this.apsPeriodStart = data?.apsPeriodStart || ''
    this.apsyear = data?.apsyear || ''
    this.checkForm = data?.checkForm ?? 0
    this.companyId = data?.companyId || ''
    this.edesc = data?.edesc || ''
    this.jd = (data?.jd || []).map(e => new MyJdModel(e))
    this.jdId = data?.jdId || ''
    this.pmsEvaluationRoundId = data?.pmsEvaluationRoundId || ''
    this.statusCode = new MyStatusCodeModel(data?.statusCode)
    this.statusFrom = new MyStatusFromModel(data?.statusFrom)
    this.tdesc = data?.tdesc || ''
  }
}

// -------------------- JD --------------------
export interface JdModel {
  companyId: string
  edesc: string
  jobCodeId: string
  statusCom: boolean
  statusPms: boolean
  tdesc: string
}

export class MyJdModel implements JdModel {
  companyId: string
  edesc: string
  jobCodeId: string
  statusCom: boolean
  statusPms: boolean
  tdesc: string
  constructor(data?: Partial<JdModel>) {
    this.companyId = data?.companyId || ''
    this.edesc = data?.edesc || ''
    this.jobCodeId = data?.jobCodeId || ''
    this.statusCom = data?.statusCom ?? false
    this.statusPms = data?.statusPms ?? false
    this.tdesc = data?.tdesc || ''
  }
}

// -------------------- StatusCode --------------------
export interface StatusCodeModel {
  code: string
  edesc: string
  tdesc: string
}

export class MyStatusCodeModel implements StatusCodeModel {
  code: string
  edesc: string
  tdesc: string
  constructor(data?: Partial<StatusCodeModel>) {
    this.code = data?.code || ''
    this.edesc = data?.edesc || ''
    this.tdesc = data?.tdesc || ''
  }
}

// -------------------- StatusFrom --------------------
export interface StatusFromModel {
  code: string
  edesc: string
  tdesc: string
}

export class MyStatusFromModel implements StatusFromModel {
  code: string
  edesc: string
  tdesc: string
  constructor(data?: Partial<StatusFromModel>) {
    this.code = data?.code || ''
    this.edesc = data?.edesc || ''
    this.tdesc = data?.tdesc || ''
  }
}

// -------------------- StatusApprove --------------------
export interface StatusApproveModel {
  code: string
  edesc: string
  tdesc: string
}

export class MyStatusApproveModel implements StatusApproveModel {
  code: string
  edesc: string
  tdesc: string
  constructor(data?: Partial<StatusApproveModel>) {
    this.code = data?.code || ''
    this.edesc = data?.edesc || ''
    this.tdesc = data?.tdesc || ''
  }
}
