/* eslint-disable no-constant-condition */
import { Component, ElementRef } from '@angular/core';
import { NavService } from '../../services/navservice';
import { AuthService } from '../../services/auth.service';
import { TokenService } from '../../services/token.service';
import { EmployeeService } from '../../services/employee.service';
import { EmployeeModel, MyEmployeeModel } from '../../model/employee.model';
import { ActivatedRoute, Router } from '@angular/router';
import { environment } from 'src/environments/environment';
import { HttpClient } from '@angular/common/http';
import { FileService } from '../../services/file.service';
import { TranslateService } from '@ngx-translate/core';

@Component({
  selector: 'app-header',
  templateUrl: './header.component.html',
  styleUrls: ['./header.component.scss'],
})

export class HeaderComponent {
  employeeProfile: EmployeeModel = new MyEmployeeModel();
  constructor(public navServices: NavService,
    private authService: AuthService,
    public tokenService: TokenService,
    private employeeService: EmployeeService,
    private elementRef: ElementRef,
    public router: Router,
    private route: ActivatedRoute,
    private fileService: FileService,
    private navService: NavService,
    private http: HttpClient,
    public translateService: TranslateService) {
    this.getEvaluatee();
    const lang = localStorage.getItem('Lang') ?? (() => {
      localStorage.setItem('Lang', 'th');
      return 'th';
    })();
    this.translateService.use(lang);
  }
  imageUrl = ''

  getEvaluatee() {
    this.employeeProfile = new MyEmployeeModel(JSON.parse(sessionStorage.getItem('employeeProfile') || '{}'));
    if (this.employeeProfile?.employeeId == undefined || this.employeeProfile?.employeeId == null || this.employeeProfile?.employeeId == '') {
      this.employeeService.getWorking().subscribe({
        next: response => {
          sessionStorage.setItem('employeeProfile', JSON.stringify(response));
          this.employeeProfile = new MyEmployeeModel(response)
        }
      })
    }

  }

  logOut() {
    this.authService.logout();
  }

  themeChange(type: string, type1: string) {
    this.elementRef.nativeElement.ownerDocument.documentElement?.setAttribute('class', type);
    this.elementRef.nativeElement.ownerDocument.documentElement?.setAttribute('style', "");
    localStorage.removeItem("synto-background-mode-body");
    localStorage.removeItem("synto-background-mode-dark");
    localStorage.setItem('synto-theme-mode', type);
    this.elementRef.nativeElement.ownerDocument.documentElement?.setAttribute('data-header-styles', type1);
    localStorage.setItem('synto-header-mode', type1);

    if (type == 'dark') {
      const darkbtn = document.querySelector(
        '#switcher-dark-theme'
      ) as HTMLInputElement;
      darkbtn.checked = true;
    } else {
      const lightbtn = document.querySelector(
        '#switcher-light-theme'
      ) as HTMLInputElement;
      lightbtn.checked = true;
    }
  }

  toggleSidebar() {
    let html = this.elementRef.nativeElement.ownerDocument.documentElement;
    if (window.innerWidth <= 992) {
      html?.setAttribute('toggled', html?.getAttribute('toggled') == 'open' ? 'close' : 'open');
      if (html?.getAttribute('toggled') == 'open') {
        document.querySelector('#responsive-overlay')?.classList.add('active');
      } else {
        document.querySelector('#responsive-overlay')?.classList.remove('active');
      }
    }
    else if (!localStorage.getItem('synto-menu-styles')) {
      html?.setAttribute('toggled', html?.getAttribute('toggled') == 'icon-overlay-close' ? '' : 'icon-overlay-close');
    } else {
      if (localStorage.getItem('synto-menu-styles') == 'menu-click') {
        html?.setAttribute('toggled', html?.getAttribute('toggled') == 'menu-click-closed' ? '' : 'menu-click-closed');
      }
      if (localStorage.getItem('synto-menu-styles') == 'menu-hover') {
        html?.setAttribute('toggled', html?.getAttribute('toggled') == 'menu-hover-closed' ? '' : 'menu-hover-closed');
      }
      if (localStorage.getItem('synto-menu-styles') == 'icon-click') {
        html?.setAttribute('toggled', html?.getAttribute('toggled') == 'icon-click-closed' ? '' : 'icon-click-closed');
      }
      if (localStorage.getItem('synto-menu-styles') == 'icon-hover') {
        html?.setAttribute('toggled', html?.getAttribute('toggled') == 'icon-hover-closed' ? '' : 'icon-hover-closed');
      }

    }
  }

  isShowDiv = false;

  removeRow(rowId: string) {
    const rowElement = document.getElementById(rowId);
    if (rowElement) {
      rowElement.remove();
    }
  }

  ngOnDestroy(): void {
    const windowObject: any = window;
    let html = this.elementRef.nativeElement.ownerDocument.documentElement;
    if (windowObject.innerWidth <= '991') {
      html?.setAttribute('toggled', 'open');
    }
    window.addEventListener('resize', () => {
      if (localStorage.getItem('synto-menu-style') != 'icon-text-close') {
        if (windowObject.innerWidth <= '991') {
          html?.setAttribute('toggled', 'open');
        } else {
          if (
            !(localStorage.getItem('synto-menu-style') == 'double-menu-open')
          ) {
            html?.removeAttribute('toggled');
          }
        }
      } else {
        document
          .querySelector('html')
          ?.setAttribute('toggled', 'icon-text-close');
      }
    });
  }

  handleCardClick(event: MouseEvent) {
    // Prevent the click event from propagating to the container
    event.stopPropagation();
  }
  removetheModal() {
    const element: any = document.querySelector('.serachmodal');
    element.click();
  }

  onImageError(event: Event) {
    const target = event.target as HTMLImageElement;
    target.src = './assets/img/users/defaultperson.jpg';
  }

  onSettingsClick() {
    this.navService.toggleEvaluationMenu();
  }

  onNextPartClick(part: string) {
    this.router.navigate([part]);
  }

  getImg(text: string) {
    return this.fileService.getImg(text)
  }

  getTokenImg() {
    return this.tokenService.getUserData().picture
  }

  switchLang(lang: string) {
    localStorage.setItem('Lang', lang);
    this.translateService.use(lang);
  }
}
