import { Component } from '@angular/core';
interface Row {
  code: string;
  name: string;
  unit: string;
  position: string;
  level: number;
  grade: string;
  score: number;
  corp: number;
  dep: number;
  ind: number;
  comp: number;
  time: number;
  cross: number;
  special: number;
  year: number;
  approve1: string;
  approve2: string;
  approve3: string;
}

@Component({
  selector: 'app-report-pms-3',
  templateUrl: './report-pms-3.component.html',
  styleUrls: ['./report-pms-3.component.scss']
})
export class ReportPms3Component {
  title = 'รายงานประเมินการปฏิบัติงานของพนักงานรายบุคคล ประจำปี 2568';

  rows: Row[] = [
    { code: '10001', name: 'กิรณา ทดสอบ', unit: 'Marketing & Procurement', position: 'Customer Key Account', level: 7, grade: 'B', score: 83.53, corp: 14.10, dep: 18.80, ind: 10.00, comp: 22.00, time: 4.73, cross: 10.00, special: 3.90, year: 2568, approve1: 'Y', approve2: 'Y', approve3: 'Y' },
    { code: '10002', name: 'บรรณ ทดสอบ', unit: 'Marketing & Procurement', position: 'Senior Marketing Strategist', level: 5, grade: 'A', score: 91.92, corp: 10.60, dep: 20.00, ind: 10.00, comp: 35.00, time: 9.82, cross: 3.00, special: 3.50, year: 2568, approve1: 'Y', approve2: 'Y', approve3: 'Y' },
    { code: '10003', name: 'ผล ทดสอบ', unit: 'Marketing & Procurement', position: 'Procurement Specialist', level: 3, grade: 'C', score: 72.30, corp: 14.10, dep: 9.30, ind: 12.30, comp: 18.00, time: 5.00, cross: 10.00, special: 3.60, year: 2568, approve1: 'Y', approve2: 'Y', approve3: 'Y' },
    { code: '10004', name: 'ณัย ทดสอบ', unit: 'Marketing & Procurement', position: 'Marketing Analyst', level: 6, grade: 'C', score: 72.70, corp: 14.10, dep: 11.20, ind: 10.40, comp: 18.00, time: 5.00, cross: 10.00, special: 4.00, year: 2568, approve1: 'Y', approve2: 'Y', approve3: 'Y' },
    { code: '10005', name: 'สคริช ทดสอบ', unit: 'Marketing & Procurement', position: 'Procurement Manager', level: 2, grade: 'C', score: 71.98, corp: 14.10, dep: 17.10, ind: 10.50, comp: 18.00, time: 4.45, cross: 4.22, special: 3.60, year: 2568, approve1: 'Y', approve2: 'Y', approve3: 'Y' },
    { code: '10006', name: 'ฟ้า ทดสอบ', unit: 'Marketing & Procurement', position: 'Marketing Coordinator', level: 3, grade: 'B', score: 83.50, corp: 14.10, dep: 9.80, ind: 16.60, comp: 24.00, time: 5.00, cross: 10.00, special: 4.00, year: 2568, approve1: 'Y', approve2: 'Y', approve3: 'Y' },
    { code: '10007', name: 'นารวิทย์ ทดสอบ', unit: 'Marketing & Procurement', position: 'Supply Chain Analyst', level: 7, grade: 'B', score: 88.00, corp: 10.60, dep: 12.80, ind: 13.60, comp: 32.67, time: 9.64, cross: 5.00, special: 3.70, year: 2568, approve1: 'Y', approve2: 'Y', approve3: 'Y' },
    { code: '10008', name: 'อาทิตย์ ทดสอบ', unit: 'Marketing & Procurement', position: 'Brand Manager', level: 2, grade: 'B', score: 89.10, corp: 10.60, dep: 14.80, ind: 15.20, comp: 32.67, time: 10.00, cross: 2.33, special: 3.50, year: 2568, approve1: 'Y', approve2: 'Y', approve3: 'Y' },
    { code: '10009', name: 'ไพโรจน์ ทดสอบ', unit: 'Marketing & Procurement', position: 'Category Manager', level: 2, grade: 'B', score: 84.76, corp: 10.60, dep: 18.80, ind: 11.20, comp: 28.00, time: 10.00, cross: 2.56, special: 3.60, year: 2568, approve1: 'Y', approve2: 'Y', approve3: 'Y' },
    { code: '10010', name: 'เมฆา ทดสอบ', unit: 'Marketing & Procurement', position: 'Market Researcher', level: 4, grade: 'B', score: 85.53, corp: 10.60, dep: 11.80, ind: 17.00, comp: 30.33, time: 10.00, cross: 2.00, special: 3.80, year: 2568, approve1: 'Y', approve2: 'Y', approve3: 'Y' },
    { code: '10011', name: 'เคม ทดสอบ', unit: 'Marketing & Procurement', position: 'Sourcing Specialist', level: 5, grade: 'C', score: 71.03, corp: 10.60, dep: 10.90, ind: 15.50, comp: 18.67, time: 9.82, cross: 2.44, special: 3.10, year: 2568, approve1: 'Y', approve2: 'Y', approve3: 'Y' }
  ];

  openReport(): void {
    const url = 'assets/reports/รายงาน_PMS3_2568_PDF.pdf';
    window.open(url, '_blank');
  }

}
