import { Component } from '@angular/core';

interface Row {
  unit: string;
  nurse: number;
  asnNurse: number;
  assistantNurse: number;
  registrar: number;
  clerk: number;
  total: number;
  reason?: string;
}

@Component({
  selector: 'app-report-com-3',
  templateUrl: './report-com-3.component.html',
  styleUrls: ['./report-com-3.component.scss']
})
export class ReportCom3Component {
  dateInfo = '1 มิ.ย. 2568';

  rows: Row[] = [
    { unit: 'หอรองรับกรณีฉุกเฉิน', nurse: 5, asnNurse: 1, assistantNurse: 1, registrar: 0, clerk: 0, total: 3 },
    { unit: 'หอผู้ป่วยเด็กเล็ก ชั้น1', nurse: 2, asnNurse: 1, assistantNurse: 1, registrar: 0, clerk: 0, total: 7 },
    { unit: 'หอผู้ป่วยเด็กโต ชั้น2', nurse: 8, asnNurse: 1, assistantNurse: 0, registrar: 0, clerk: 0, total: 9 },
    { unit: 'หอผู้ป่วยเด็กโต ชั้น3', nurse: 4, asnNurse: 0, assistantNurse: 1, registrar: 1, clerk: 0, total: 6 },
    { unit: 'ศูนย์เฝ้าระวัง', nurse: 0, asnNurse: 0, assistantNurse: 0, registrar: 0, clerk: 12, total: 12 },
    { unit: 'หน่วยจ่ายกลาง', nurse: 0, asnNurse: 0, assistantNurse: 4, registrar: 0, clerk: 2, total: 6 },
    { unit: 'ห้องคลอด', nurse: 9, asnNurse: 3, assistantNurse: 1, registrar: 0, clerk: 0, total: 13 },
    { unit: 'หน่วยอุบัติเหตุฉุกเฉิน', nurse: 10, asnNurse: 4, assistantNurse: 0, registrar: 1, clerk: 0, total: 15 },
    { unit: 'หอผู้ป่วยวิกฤติ', nurse: 3, asnNurse: 2, assistantNurse: 0, registrar: 1, clerk: 0, total: 6 },
    { unit: 'สำนักงานฝ่ายพยาบาล', nurse: 2, asnNurse: 0, assistantNurse: 0, registrar: 3, clerk: 0, total: 5 },
    { unit: 'หอผู้ป่วยเด็กเล็ก ชั้น1', nurse: 4, asnNurse: 0, assistantNurse: 0, registrar: 0, clerk: 0, total: 4 },
    { unit: 'หอผู้ป่วยเด็กโต ชั้น2', nurse: 5, asnNurse: 1, assistantNurse: 0, registrar: 0, clerk: 0, total: 6 },
    { unit: 'ห้องผ่าตัด', nurse: 5, asnNurse: 1, assistantNurse: 0, registrar: 0, clerk: 2, total: 8 }
  ];

  get grand(): Row {
    const g = { unit: 'รวม', nurse: 0, asnNurse: 0, assistantNurse: 0, registrar: 0, clerk: 0, total: 0 };
    this.rows.forEach(r => {
      g.nurse += r.nurse; g.asnNurse += r.asnNurse; g.assistantNurse += r.assistantNurse;
      g.registrar += r.registrar; g.clerk += r.clerk; g.total += r.total;
    });
    return g;
  }
}
