import { ChangeDetectorRef, Component, EventEmitter, Input, Output } from '@angular/core';
import { ToastrService } from 'ngx-toastr';

export interface DataModel {
    check: boolean,
    code: string,
    period: string,
    year: string,
    startDate: string,
    endDate: string,
    status: string
}

@Component({
    selector: 'app-document-form',
    templateUrl: './document-form.component.html',
    styleUrls: ['./document-form.component.scss']
})
export class DocumentFormComponent {
@Input() pathTitle = ['การประเมินจัดการประสิทธิภาพ', 'รอบการประเมิน', 'กำหนดฟอร์มเอกสาร'];
@Output() sendPathTitle: EventEmitter<string[]> = new EventEmitter<string[]>();
@Output() sendGroupShow: EventEmitter<string> = new EventEmitter<string>();
activeTab: string = 'tab1'; // กำหนด tab เริ่มต้น
  
onEdit(){
    this.sendGroupShow.emit('2');
  }

  // ฟังก์ชันในการเปลี่ยนแท็บ
  changeTab(tab: { id: string, text: string }) {
    this.sendPathTitle.emit(['การประเมินจัดการประสิทธิภาพ', 'การจัดการประเมิน', tab.text]);
    this.activeTab = tab.id;
  }
    currentPage = 1
    page = Array.from({ length: 1 }, (_, i) => i + 1);
    search = ""
    numDataListChecked = 0
    isDataListChecked = false
    isDataListCheckedAll = false
    dataList: DataModel[] = [
        {
            check: false,
            code: "Y67P2",
            period: "ช่วงเวลาที่ 2",
            year: "2567",
            startDate: "01-07-2567",
            endDate: "31-12-2567",
            status: "1"
        },
        {
            check: false,
            code: "Y68P1",
            period: "ช่วงเวลาที่ 1",
            year: "2568",
            startDate: "01-01-2568",
            endDate: "30-06-2568",
            status: "2"
        },
    ]
    dataSelect: DataModel = {
        check: false,
        code: "",
        period: "",
        year: "",
        startDate: "",
        endDate: "",
        status: "",
    }
    modalStatus: "add" | "edit" = "add"
    constructor(private toastr: ToastrService, private cdr: ChangeDetectorRef) {
    }

    dataListSelect(data?: DataModel) {
        this.dataSelect = data || {
            check: false,
            code: "",
            period: "",
            year: "",
            startDate: "",
            endDate: "",
            status: "",
        }
        this.cdr.detectChanges()
    }

    dataListFilter() {
        return this.dataList.filter(x => {
            const match = x.code.includes(this.search) || x.period.includes(this.search);
            if (!match) x.check = false;
            return match;
        });
    }

    dataListCheck() {
        const dataCheck = this.dataListFilter();
        this.isDataListChecked = dataCheck.some(x => x.check);
        this.isDataListCheckedAll = dataCheck.length ? dataCheck.every(x => x.check) : false;
        this.numDataListChecked = dataCheck.filter(x => x.check).length;
    }

    dataListCheckAll() {
        const selectAll = this.isDataListCheckedAll;
        this.dataList.forEach(x => x.check = selectAll);
        this.dataListCheck();
    }

    searchChange() {
        this.currentPage = 1;
        const filteredData = this.dataListFilter();
        this.page = Array.from({ length: Math.ceil(filteredData.length / 10) }, (_, i) => i + 1);
        this.dataListCheck();
    }

    modalOptions: {
        [nameModal: string]: {
          isModalOpen: boolean;
          modalSize: string;
          backdropClose: boolean;
        };
      } = {
        "add": {
          isModalOpen: false,
          modalSize: 'm',
          backdropClose: true,
        },
        "edit": {
          isModalOpen: false,
          modalSize: 'm',
          backdropClose: true,
        }
      };
    openModal(name: string, size: string, closeOnBackdrop?: boolean) {
        this.modalOptions[name].modalSize = size;
        this.modalOptions[name].backdropClose = closeOnBackdrop || false;
        this.modalOptions[name].isModalOpen = true;
        this.currentModal = name;  // ตั้งค่าค่าของ currentModal เป็น 'add' หรือ 'edit'
        document.body.style.overflow = 'hidden';
      }
    
      closeModal(name: string) {
        this.modalOptions[name].isModalOpen = false;
        if (!this.isAnyModalOpen()) {
          document.body.style.overflow = ''; // คืนค่าการ Scroll เฉพาะเมื่อ Modal ทั้งหมดปิดแล้ว
        }
      }
    
      isAnyModalOpen(): boolean {
        return Object.values(this.modalOptions).some(modal => modal.isModalOpen); // ตรวจสอบว่า modal อื่นยังเปิดอยู่หรือไม่
      }
    
      // ฟังก์ชัน toggle checkbox
      isChecked: boolean = false; // ใช้สำหรับตรวจสอบสถานะของ checkbox
      
      toggleCheckbox() {
        this.isChecked = !this.isChecked; // สลับสถานะ
      }
    
      // ฟังก์ชันสำหรับการเพิ่ม ลบ หรือแก้ไข ข้อมูล
      addUser() {
    
      }
      
      currentModal = "";
      
    //   constructor(private toastr: ToastrService) { }
    
      showSuccess() {
        this.toastr.success('บันทึกข้อมูลสำเร็จ', 'เเจ้งเตือน', {
          timeOut: 3000,
          positionClass: 'toast-top-right',
        });
      }
    
      showSuccessEdit() {
        this.toastr.success('เเก้ไขข้อมูลสำเร็จ', 'เเจ้งเตือน', {
          timeOut: 3000,
          positionClass: 'toast-top-right',
        });
      }
    
      showSuccessDelete() {
        this.toastr.success('ลบข้อมูลสำเร็จ', 'เเจ้งเตือน', {
          timeOut: 3000,
          positionClass: 'toast-top-right',
        });
      }
}

