import { Component, EventEmitter, Input, Output } from '@angular/core';
import { Router } from '@angular/router';
type ModuleCard = { link: string, icon: string; title: string };
@Component({
  selector: 'app-my-skill-x-module',
  templateUrl: './my-skill-x-module.component.html',
  styleUrls: ['./my-skill-x-module.component.scss']
})
export class MySkillXModuleComponent {
  hrdModules: ModuleCard[] = [
    { link: '/ess/employee-self-service', icon: 'assets/img/logos/HRD/1.png', title: 'Performance & Competency' },
    { link: '/ess/onboarding-program', icon: 'assets/img/logos/HRD/2.png', title: 'On-Boarding Program' },
    { link: '/ess/talent-successor', icon: 'assets/img/logos/HRD/3.png', title: 'Talent & Successor' },
    { link: '/ess/career-Path', icon: 'assets/img/logos/HRD/4.png', title: 'Career Path' },
    { link: '/ess/training-roadmap', icon: 'assets/img/logos/HRD/5.png', title: 'Training Roadmap' },
    { link: '/ess/leadership-development', icon: 'assets/img/logos/HRD/6.png', title: 'Leadership' }
  ];

  hrmModules: ModuleCard[] = [
    { link: '/ess/workforce', icon: 'assets/img/logos/HDM/1.png', title: 'Workforce' },
    { link: '/ess/compensation', icon: 'assets/img/logos/HDM/2.png', title: 'Compensation' },
    { link: '/ess/salary-survey', icon: 'assets/img/logos/HDM/3.png', title: 'Salary Survey' },
    { link: '/ess/recruitment-selection', icon: 'assets/img/logos/HDM/4.png', title: 'Recruit & Selection' },
    { link: '/ess/job-management', icon: 'assets/img/logos/HDM/5.png', title: 'Job Management' },
    { link: '/ess/welfare-reward', icon: 'assets/img/logos/HDM/6.png', title: 'Welfare & Reward' }
  ];
  constructor(private router: Router) { }

  goTo(link?: string) {
    if (link) {
      this.router.navigate([link]);

    } else {
      window.open('https://www.myhr.co.th/', '_blank');
    }
  }
}
