import { ViewportScroller } from '@angular/common';
import { ChangeDetectorRef, Component } from '@angular/core';
import { MatDialog } from '@angular/material/dialog';
import { TranslateService } from '@ngx-translate/core';
import { ToastrService } from 'ngx-toastr';
import { EmployeeModel, MyEmployeeModel } from 'src/app/shared/model/employee.model';
import { JobCodeModel, MyJobCodeModel } from 'src/app/shared/model/job-code.model';
import { MyStatusModel, StatusModel } from 'src/app/shared/model/status.model';
import { EmpStatusService } from 'src/app/shared/services/emp-status.service';
import { EmployeeService } from 'src/app/shared/services/employee.service';
import { EventgrpService } from 'src/app/shared/services/eventgrp.service';
import { FileService } from 'src/app/shared/services/file.service';
import { JobcodeService } from 'src/app/shared/services/jobcode.service';
import { PmsWorkingTimeService } from 'src/app/shared/services/pms-working-time.service';
export interface BiModel {
  name: string,
  tools: string[],
  degree: string
}

@Component({
  selector: 'app-job-description-emp',
  templateUrl: './job-description-emp.component.html',
  styleUrls: ['./job-description-emp.component.scss']
})
export class JobDescriptionEmpComponent {
  pathTitle = ['menu.Organization', 'ข้อมูลลักษณะงาน (JD)']
  currentPage = 1

  empDetail: { loading: boolean, data: JobCodeModel } = { loading: false, data: new MyJobCodeModel({}) }
  constructor(
    private toastr: ToastrService,
    private cdr: ChangeDetectorRef,
    private dialog: MatDialog,
    private fileService: FileService,
    private eventgrpService: EventgrpService,
    private jobcode: JobcodeService,
    private translateService: TranslateService
  ) {
    this.translateService.onLangChange.subscribe((event) => {
    });
  }
  ngOnInit(): void {
    this.getEmp()
  }
  getEmp() {
    this.empDetail.loading = true
    this.jobcode.getEmp().subscribe({
      next: response => {
        this.empDetail.data = new MyJobCodeModel(response)
        this.empDetail.loading = false
        this.cdr.detectChanges()
      }, error: error => {
        this.empDetail.loading = false
        this.cdr.detectChanges()
      }
    })
  }
}