import { NgModule } from '@angular/core';
import { CommonModule } from '@angular/common';

import { DashboardRoutingModule } from './dashboard-routing.module';
import { SalesComponent } from './sales/sales.component';
import { EcommerceComponent } from './ecommerce/ecommerce.component';
import { CryptoComponent } from './crypto/crypto.component';
import { JobsComponent } from './jobs/jobs.component';
import { NftComponent } from './nft/nft.component';
import { AnalyticsComponent } from './analytics/analytics.component';
import { ProjectsComponent } from './projects/projects.component';
import { HrmComponent } from './hrm/hrm.component';
import { CrmComponent } from './crm/crm.component';
import { PersonalComponent } from './personal/personal.component';
import { StocksComponent } from './stocks/stocks.component';
import { CourseComponent } from './course/course.component';
import { NgApexchartsModule } from 'ng-apexcharts';
import { NgChartsModule } from 'ng2-charts';
import { CarouselModule } from 'ngx-owl-carousel-o';
import { SharedModule } from 'src/app/shared/sharedmodule';
import { NgxChartsModule } from '@swimlane/ngx-charts';
import { NgSelectModule } from '@ng-select/ng-select';
import { CompanyRegistrationComponent } from '../company-components/company-registration/company-registration.component';
import { DepartmentRegisterComponent } from '../company-components/company-registration/branch-business-unit/department-register/department-register.component';
import { BranchBusinessUnitComponent } from '../company-components/company-registration/branch-business-unit/branch-business-unit.component';
import { DepartmentListComponent } from '../company-components/company-registration/branch-business-unit/department-list/department-list.component';
import { SubDepartmentOneComponent } from '../company-components/company-registration/branch-business-unit/sub-department-one/sub-department-one.component';
import { SubDepartmentThreeComponent } from '../company-components/company-registration/branch-business-unit/sub-department-three/sub-department-three.component';
import { SubDepartmentTwoComponent } from '../company-components/company-registration/branch-business-unit/sub-department-two/sub-department-two.component';
import { SubDepartmentFourComponent } from '../company-components/company-registration/branch-business-unit/sub-department-four/sub-department-four.component';
import { SectionRegistrationComponent } from '../company-components/company-registration/branch-business-unit/section-registration/section-registration.component';
import { HTTP_INTERCEPTORS, provideHttpClient, withInterceptorsFromDi } from '@angular/common/http';
import { Bu1Service } from 'src/app/shared/services/bu1.service';
import { HttpRequestInterceptor } from 'src/app/shared/services/http-request.interceptor';
import { FormsModule } from '@angular/forms';
import { Bu2Service } from 'src/app/shared/services/bu2.service';
import { Bu3Service } from 'src/app/shared/services/bu3.service';
import { Bu4Service } from 'src/app/shared/services/bu4.service';
import { Bu5Service } from 'src/app/shared/services/bu5.service';
import { Bu6Service } from 'src/app/shared/services/bu6.service';
import { Bu7Service } from 'src/app/shared/services/bu7.service';
import { PositionService } from 'src/app/shared/services/position.service';
import { PLService } from 'src/app/shared/services/pl.service';
import { EmpGroupService } from 'src/app/shared/services/emp-group.service';
import { EmpTypeService } from 'src/app/shared/services/employee-type.service';
import { JobDetailManagementComponent } from '../job-detail-components/job-detail-management/job-detail-management.component';
import { ImportDataComponent } from '../job-detail-components/job-detail-management/import-data/import-data.component';
import { JobDescriptionComponent } from '../company-components/job-description/job-description.component';
import { PositionUnitComponent } from '../company-components/job-description/position/position-unit.component';
import { EmployeeGroupUnit } from '../company-components/job-description/employee-group-unit/employee-group-unit.component';
import { EmployeeCategories } from '../company-components/job-description/employee-categories/employee-categories.component';
import { EmployeeLevel } from '../company-components/job-description/employee-level/employee-level.component';
import { AccountSettingsComponent } from '../company-components/account-settings/account-settings.component';
import { UserSettingsComponent } from '../company-components/account-settings/user-settings/user-settings.component';
import { SetAPasswordComponent } from '../company-components/account-settings/set-a-password/set-a-password.component';
import { NameRegistrationComponent } from '../competency-assessment/name-registration/name-registration.component';
import { TypeRegistration } from '../competency-assessment/name-registration/type-registration/type-registration.component';
import { CompetencyTopic } from '../competency-assessment/name-registration/competency-topic/competency-topic.component';
import { ToolRegisterComponent } from '../competency-assessment/tool-register/tool-register.component';
import { AssessmentToolComponent } from '../competency-assessment/tool-register/assessment-tool/assessment-tool.component';
import { CourseRegistrationComponent } from '../competency-assessment/course-registration/course-registration.component';
import { DevelopmentCourseComponent } from '../competency-assessment/course-registration/development-course/development-course.component';
import { CompetencyManagementComponent } from '../competency-assessment/competency-management/competency-management.component';
import { IndicatorsAndCurriculumComponent } from '../competency-assessment/competency-management/indicators-and-curriculum/indicators-and-curriculum.component';
import { EditGroupIndicators } from '../competency-assessment/competency-management/indicators-and-curriculum/edit-group-indicators/edit-group-indicators.component';
import { GroupCompetenciesComponent } from '../competency-assessment/competency-management/group-competencies/group-competencies.component';
import { EditGroupCompetenciesComponent } from '../competency-assessment/competency-management/group-competencies/edit-group-competencies/edit-group-competencies.component';
import { EvaluationCycleManagerComponent } from '../competency-assessment/evaluation-cycle-manager/evaluation-cycle-manager.component';
import { EvaluationCycleComponent } from '../competency-assessment/evaluation-cycle-manager/evaluation-cycle/evaluation-cycle.component';
import { SettingCompetencyComponent } from '../competency-assessment/setting-competency/setting-competency.component';
import { CompetencyConfigurationComponent } from '../competency-assessment/setting-competency/competency-configuration/competency-configuration.component';
import { IdpDevelopmentPlanComponent } from '../competency-assessment/idp-development-plan/idp-development-plan.component';
import { SetIdpDevelopmentPlanComponent } from '../competency-assessment/idp-development-plan/set-idp-development-plan/set-idp-development-plan.component';
import { NgxDaterangepickerMd } from 'ngx-daterangepicker-material';
import { JobCompetencyComponent } from '../job-detail-components/job-competency/job-competency.component';
import { SubJobCompetencyComponent } from '../job-detail-components/job-competency/sub-job-competency/sub-job-competency.component';
import { JobQualificationsComponent } from '../job-detail-components/job-qualifications/job-qualifications.component';
import { SubJobQualificationsComponent } from '../job-detail-components/job-qualifications/sub-job-qualifications/sub-job-qualifications.component';
import { JobDetailComponent } from '../job-detail-components/job-detail/job-detail.component';
import { WorkDetailComponent } from '../job-detail-components/job-detail/work-detail/work-detail.component';
import { SubCommandStructureComponent } from '../job-detail-components/command-structure/sub-command-structure/sub-command-structure.component';
import { CommandStructureComponent } from '../job-detail-components/command-structure/command-structure.component';
import { AssessmentManagementComponent } from '../performance-management-evaluation/assessment-management/assessment-management.component';
import { AssigningApproversComponent } from '../performance-management-evaluation/assessment-management/assigning-approvers/assigning-approvers.component';
import { SubJobPositionIndicatorsComponent } from '../job-detail-components/job-position-indicators/sub-job-position-indicators/sub-job-position-indicators.component';
import { DefineDocumentFormComponent } from '../competency-assessment/evaluation-cycle-manager/define-document-form/define-document-form.component';
import { EditDefineDocumentFormComponent } from '../competency-assessment/evaluation-cycle-manager/define-document-form/edit-define-document-form/edit-define-document-form.component';
import { EvaluationCyclePerformanceComponent } from '../performance-management-evaluation/evaluation-cycle-performance/evaluation-cycle-performance.component';
import { DocumentFormComponent } from '../performance-management-evaluation/evaluation-cycle-performance/document-form/document-form.component';
import { EditEvaluationFormComponent } from '../performance-management-evaluation/evaluation-cycle-performance/document-form/edit-evaluation-form/edit-evaluation-form.component';
import { SupervisorEvaluationComponent } from '../performance-evaluation/supervisor-evaluation/supervisor-evaluation.component';
import { EmployeeRegistrationComponent } from '../company-components/employee-registration/employee-registration.component';
import { SubEmployeeRegistrationComponent } from '../company-components/employee-registration/sub-employee-registration/sub-employee-registration.component';
import { SetApproversComponent } from '../competency-assessment/competency-management/set-approvers/set-approvers.component';
import { NameRegistrationPerfomanceComponent } from '../performance-management-evaluation/name-registration-perfomance/name-registration-perfomance.component';
import { AssessmentTypesComponent } from '../performance-management-evaluation/name-registration-perfomance/assessment-types/assessment-types.component';
import { EvaluationGroupingComponent } from '../performance-management-evaluation/assessment-management/evaluation-grouping/evaluation-grouping.component';
import { EditEvaluationGroupingComponent } from '../performance-management-evaluation/assessment-management/evaluation-grouping/edit-evaluation-grouping/edit-evaluation-grouping.component';
import { JobPositionIndicatorsComponent } from '../job-detail-components/job-position-indicators/job-position-indicators.component';
import { AssessmentTopicsComponent } from '../performance-management-evaluation/name-registration-perfomance/assessment-topics/assessment-topics.component';
import { ManagementCycleComponent } from '../performance-management-evaluation/evaluation-cycle-performance/management-evaluation-cycle/management-evaluation-cycle.component';
import { EvaluationFactorsComponent } from '../performance-management-evaluation/evaluation-factors/evaluation-factors.component';
import { DefineEvaluationFactorsComponent } from '../performance-management-evaluation/evaluation-factors/define-evaluation-factors/define-evaluation-factors.component';
import { GradeRegistrationComponent } from '../competency-assessment/grade-registration/grade-registration.component';
import { GradeManagementComponent } from '../competency-assessment/grade-registration/grade-management/grade-management.component';
import { GroupGradeComponent } from '../competency-assessment/grade-registration/grade-management/group-grade/group-grade.component';
import { SubGradeRegistrationComponent } from '../competency-assessment/grade-registration/grade-management/sub-grade-registration/sub-grade-registration.component';
import { SettingPerformanceEvalutionComponent } from '../performance-management-evaluation/setting-performance-evalution/setting-performance-evalution.component';
import { AssessmentSystemConfigurationComponent } from '../performance-management-evaluation/setting-performance-evalution/assessment-system-configuration/assessment-system-configuration.component';
import { SelfEvaluationComponent } from '../performance-evaluation/self-evaluation/self-evaluation.component';
import { CompanyRegistrationPageComponent } from '../company-components/company-registration/company-registration-page/company-registration-page.component';
import { CompanyService } from 'src/app/shared/services/company.service';
import { CompetencytypeService } from 'src/app/shared/services/competencytype.service';
import { CompetencytopicService } from 'src/app/shared/services/competencytopic.service';
import { AssessmentService } from 'src/app/shared/services/assessment.service';
import { CompetencycourseService } from 'src/app/shared/services/competencycourse.service';
import { EmployeeService } from 'src/app/shared/services/employee.service';
import { EvaluationCycleService } from 'src/app/shared/services/evaluation-cycle.service';
import { SettingAssessmentService } from 'src/app/shared/services/setting-assessment.service';
import { MatDatepickerModule } from '@angular/material/datepicker';
import { MatNativeDateModule } from '@angular/material/core';
import { MatFormFieldModule } from '@angular/material/form-field';
import { MatIconModule } from '@angular/material/icon';
import { MatInputModule } from '@angular/material/input';
import { DateAdapter, MAT_DATE_FORMATS } from '@angular/material/core';
import { NativeDateAdapter } from '@angular/material/core';
import { BranchService } from 'src/app/shared/services/่branch.service';
import { JobCodeService } from 'src/app/shared/services/job-code.service';
import { FileService } from 'src/app/shared/services/file.service';
import { CompetencyGroupGradeService } from 'src/app/shared/services/competency-group-grade.service';
import { IndicatorsCoursesService } from 'src/app/shared/services/indicators-courses.service';
import { IdpDevelopmentService } from 'src/app/shared/services/idp-development.service';
import { GroupAssessmentService } from 'src/app/shared/services/group-assessment.service';
import { GroupApproveService } from 'src/app/shared/services/group-approve.service';
import { UserService } from 'src/app/shared/services/user.service';
import { ManageUserComponent } from '../company-components/account-settings/manage-user/manage-user.component';
import { PmstypeService } from 'src/app/shared/services/pmstype.service';
import { PmstopicService } from 'src/app/shared/services/pmstopic.service';
import { PmsGroupAssessmentService } from 'src/app/shared/services/pms-group-assessment.service';
import { PmsGroupApproveService } from 'src/app/shared/services/pms-group-approve.service';
import { PmsEvaluationFactorsService } from 'src/app/shared/services/pms-evaluation-factors.service';
import { PmsMasfromEvaluationCycleService } from 'src/app/shared/services/pms-masfrom-evaluation.service';
import { PmsGroupGradeService } from 'src/app/shared/services/pms-group-grade.service';
import { PmsSettingAssessmentService } from 'src/app/shared/services/pms-setting-assessment.service';
import { PmsGradeRegistrationComponent } from '../performance-management-evaluation/pms-grade-registration/pms-pms-grade-registration.component';
import { PmsGradeManagementComponent } from '../performance-management-evaluation/pms-grade-registration/pms-grade-management/pms-grade-management.component';
import { PmsSubGradeRegistrationComponent } from '../performance-management-evaluation/pms-grade-registration/pms-grade-management/pms-sub-grade-registration/pms-sub-grade-registration.component';
import { PmsGroupGradeComponent } from '../performance-management-evaluation/pms-grade-registration/pms-grade-management/pms-group-grade/pms-group-grade.component';
import { EvaluationAssessmentService } from 'src/app/shared/services/evaluation-assessment.service';
import { AppraisalService } from 'src/app/shared/services/appraisal.service';
import { DayTypeRegistryComponent } from '../company-components/day-type-registry/day-type-registry.component';
import { EventgrpService } from 'src/app/shared/services/eventgrp.service';
import { PmsEvaluationCycleService } from 'src/app/shared/services/pms-evaluation-cycle.service';
import { PmsEvaluationAssessmentService } from 'src/app/shared/services/pms-evaluation-assessment.service';
import { TimeAttendanceComponent } from '../performance-management-evaluation/time-attendance/time-attendance.component';
import { PmsWorkingTimeService } from 'src/app/shared/services/pms-working-time.service';
import { EvaluationIdpService } from 'src/app/shared/services/evaluation-Idp.service';
import { EmpStatusService } from 'src/app/shared/services/emp-status.service';
import { PaginationComponent } from '../pagination/pagination.component';
import { RolePermissionConfigComponent } from '../company-components/account-settings/role-permission-config/role-permission-config.component';
import { ConfigPermissionService } from 'src/app/shared/services/config-permission.service';
import { TimeAttendanceManageComponent } from '../performance-management-evaluation/time-attendance/time-attendance-manage/time-attendance-manage.component';
import { TimeAttendanceStatisticsComponent } from '../performance-management-evaluation/time-attendance/time-attendance-statistics/time-attendance-statistics.component';
import { TokenService } from 'src/app/shared/services/token.service';
import { GridModule } from '@syncfusion/ej2-angular-grids'
import { DropDownListModule } from '@syncfusion/ej2-angular-dropdowns';
import { RatingModule } from '@syncfusion/ej2-angular-inputs';
import { DatagridSyncfutionComponent } from '../datagrid-syncfution/datagrid-syncfution.component';
import { MatDialogModule } from '@angular/material/dialog';
import { PmsFormEmployeeComponent } from '../performance-evaluation/pms-form-employee/pms-form-employee.component';
import { DpDatePickerModule } from 'ng2-date-picker';
import { PmsInformationComponent } from '../performance-evaluation/pms-form-employee/pms-information/pms-information.component';
import { PmsCompetencyComponent } from '../performance-evaluation/pms-form-employee/pms-competency/pms-competency.component';
import { PmsKpiComponent } from '../performance-evaluation/pms-form-employee/pms-kpi/pms-kpi.component';
import { PmsIdpComponent } from '../performance-evaluation/pms-form-employee/pms-idp/pms-idp.component';
import { BarRatingModule } from 'ngx-bar-rating';
import { EmployeeSelfServiceComponent } from '../employee-self-service/employee-self-service.component';
import { MySkillXModuleComponent } from '../my-skill-x-module/my-skill-x-module.component';
import { DashboardEvaluationComponent } from './projects/dashboard-evaluation.component';
import { NgxEchartsModule } from 'ngx-echarts';
import { ReportCom1Component } from '../report-component/report-com/report-com-1/report-com-1.component';
import { ReportCom2Component } from '../report-component/report-com/report-com-2/report-com-2.component';
import { ReportCom3Component } from '../report-component/report-com/report-com-3/report-com-3.component';
import { ReportPms1Component } from '../report-component/report-pms/report-pms-1/report-pms-1.component';
import { ReportPms2Component } from '../report-component/report-pms/report-pms-2/report-pms-2.component';
import { ReportPms3Component } from '../report-component/report-pms/report-pms-3/report-pms-3.component';
import { EssProfileComponent } from '../ess-profile/ess-profile.component';
import { ExcelReportComponent } from '../excel-report/excel-report.component';
import { PivotSyncfutionComponent } from '../pivot-syncfution/pivot-syncfution.component';
import { CalculatedFieldService, ConditionalFormattingService, DrillThroughService, FieldListService, GroupingBarService, NumberFormattingService, PivotFieldListModule, PivotViewModule, ToolbarService, VirtualScrollService } from '@syncfusion/ej2-angular-pivotview';
import {
  ChartModule,
  LineSeriesService,
  ColumnSeriesService,
  CategoryService,
  LegendService,
  TooltipService
} from '@syncfusion/ej2-angular-charts';
import {
  ResizeService,
  SortService,
  PageService,
  FilterService,
} from '@syncfusion/ej2-angular-grids';
import { SettingIndividualKpiComponent } from '../setting-individual-kpi/setting-individual-kpi.component';
import { SettingIndividualKpiSupervisorComponent } from '../setting-individual-kpi-supervisor/setting-individual-kpi-supervisor.component';
import { MoneyInputDirective } from 'src/app/shared/directive/money-input/money-input.directive';
import { CompetencyEvaluationFactorsComponent } from '../competency-assessment/competency-evaluation-factors/competency-evaluation-factors.component';
import { CompetencyDefineEvaluationFactorsComponent } from '../competency-assessment/competency-evaluation-factors/competency-define-evaluation-factors/competency-define-evaluation-factors.component';
import { TranslateModule } from '@ngx-translate/core';
import { ReportCompetencySummaryComponent } from '../report-component/report-com/report-competency-summary/report-competency-summary.component';
import { JobDescriptionEmpComponent } from '../job-description-emp/job-description-emp.component';
import { CompetencyMappingComponent } from '../competency-mapping/competency-mapping.component';
import { JobFamilyComponent } from '../company-components/job-description/job-family/job-family.component';
import { JobGradeComponent } from '../company-components/job-description/job-grade/job-grade.component';
import { JobGradeGroupComponent } from '../company-components/job-description/job-grade-group/job-grade-group.component';
import { JobFamilyMappingComponent } from '../job-family-mapping/job-family-mapping.component';
import { JobFamilyMatrixComponent } from '../job-family-matrix/job-family-matrix.component';
import { DocumentUploadManagerComponent } from '../company-components/account-settings/document-upload-manager/document-upload-manager.component';
import { DisciplinaryActionComponent } from '../disciplinary-action/disciplinary-action.component';
import { OutstandingPerformanceComponent } from '../outstanding-performance/outstanding-performance.component';
import { PostEvaluationTrackingComponent } from '../post-evaluation-tracking/post-evaluation-tracking.component';
import { EvaluationConfirmationComponent } from '../post-evaluation-tracking/evaluation-confirmation/evaluation-confirmation.component';
import { GapTrackingComponent } from '../post-evaluation-tracking/gap-tracking/gap-tracking.component';
import { GapTrackingSupervisorComponent } from '../post-evaluation-tracking/gap-tracking-supervisor/gap-tracking-supervisor.component';
import { OnboardingProgramComponent } from '../onboarding-program/onboarding-program.component';
import { TalentSuccessorComponent } from '../talent-successor/talent-successor.component';
import { CareerPathComponent } from '../career-path/career-path.component';
import { TrainingrRoadmapComponent } from '../training-roadmap/training-roadmap.component';
import { LeadershipDevelopmentComponent } from '../leadership-development/leadership-development.component';
import { WorkforceComponent } from '../workforce/workforce.component';
import { CompensationComponent } from '../compensation/compensation.component';
import { SalarySurveyComponent } from '../salary-survey/salary-survey.component';
import { RecruitmentSelectionComponent } from '../recruitment-selection/recruitment-selection.component';
import { JobManagementComponent } from '../job-management/job-management.component';
import { WelfareRewardComponent } from '../welfare-reward/welfare-reward.component';
import { TimeAttendanceWizardComponent } from '../time-attendance-wizard/time-attendance-wizard.component';
import { ReviewHistoryComponent } from '../review-history/review-history.component';
import { CalibrateComponent } from '../calibrate/calibrate.component';

export const MY_DATE_FORMATS = {
  parse: {
    dateInput: 'DD-MM-YYYY',  // รูปแบบที่ใช้สำหรับการแปลงวันที่จาก input
  },
  display: {
    dateInput: 'DD-MM-YYYY',  // รูปแบบที่ใช้ในการแสดงวันที่
    monthYearLabel: 'MMM YYYY',
    dateA11yLabel: 'DD-MM-YYYY',
    monthYearA11yLabel: 'MMMM YYYY',
  },
};

export class CustomDateAdapter extends NativeDateAdapter {
  override format(date: Date, displayFormat: object): string {
    if (typeof displayFormat === 'string' && displayFormat === 'DD-MM-YYYY') {
      return `${date.getDate().toString().padStart(2, '0')}/${(date.getMonth() + 1)
        .toString()
        .padStart(2, '0')}/${date.getFullYear()}`;
    } else {
      return super.format(date, displayFormat);
    }
  }
}

@NgModule({
  declarations: [
    SalesComponent,
    EcommerceComponent,
    CryptoComponent,
    JobsComponent,
    NftComponent,
    AnalyticsComponent,
    ProjectsComponent,
    HrmComponent,
    CrmComponent,
    PersonalComponent,
    StocksComponent,
    CourseComponent,
    // my Component
    CompanyRegistrationComponent,
    BranchBusinessUnitComponent,
    DepartmentRegisterComponent,
    DepartmentListComponent,
    SectionRegistrationComponent,
    SubDepartmentOneComponent,
    SubDepartmentTwoComponent,
    SubDepartmentThreeComponent,
    SubDepartmentFourComponent,
    JobDescriptionComponent,
    PositionUnitComponent,
    EmployeeGroupUnit,
    EmployeeCategories,
    AccountSettingsComponent,
    UserSettingsComponent,
    EmployeeLevel,
    SetAPasswordComponent,
    NameRegistrationComponent,
    TypeRegistration,
    CompetencyTopic,
    ToolRegisterComponent,
    AssessmentToolComponent,
    CompetencyManagementComponent,
    JobDetailManagementComponent,
    CourseRegistrationComponent,
    DevelopmentCourseComponent,
    IndicatorsAndCurriculumComponent,
    ImportDataComponent,
    EditGroupIndicators,
    GroupCompetenciesComponent,
    EditGroupCompetenciesComponent,
    EvaluationCycleManagerComponent,
    EvaluationCycleComponent,
    SettingCompetencyComponent,
    CompetencyConfigurationComponent,
    IdpDevelopmentPlanComponent,
    SetIdpDevelopmentPlanComponent,
    JobCompetencyComponent,
    SubJobCompetencyComponent,
    JobQualificationsComponent,
    SubJobQualificationsComponent,
    JobDetailComponent,
    WorkDetailComponent,
    CommandStructureComponent,
    SubCommandStructureComponent,
    AssessmentManagementComponent,
    AssigningApproversComponent,
    JobPositionIndicatorsComponent,
    SubJobPositionIndicatorsComponent,
    DefineDocumentFormComponent,
    EditDefineDocumentFormComponent,
    EvaluationCyclePerformanceComponent,
    DocumentFormComponent,
    EditEvaluationFormComponent,
    SupervisorEvaluationComponent,
    PmsFormEmployeeComponent,
    EmployeeRegistrationComponent,
    SubEmployeeRegistrationComponent,
    AssessmentTopicsComponent,
    SetApproversComponent,
    NameRegistrationPerfomanceComponent,
    AssessmentTypesComponent,
    EvaluationGroupingComponent,
    EditEvaluationGroupingComponent,
    ManagementCycleComponent,
    EvaluationFactorsComponent,
    DefineEvaluationFactorsComponent,
    CompetencyEvaluationFactorsComponent,
    CompetencyDefineEvaluationFactorsComponent,
    GradeRegistrationComponent,
    GradeManagementComponent,
    GroupGradeComponent,
    SubGradeRegistrationComponent,
    SettingPerformanceEvalutionComponent,
    AssessmentSystemConfigurationComponent,
    SelfEvaluationComponent,
    CompanyRegistrationPageComponent,
    ManageUserComponent,
    PmsGradeRegistrationComponent,
    PmsGradeManagementComponent,
    PmsGroupGradeComponent,
    PmsSubGradeRegistrationComponent,
    DayTypeRegistryComponent,
    TimeAttendanceComponent,
    PaginationComponent,
    RolePermissionConfigComponent,
    TimeAttendanceManageComponent,
    TimeAttendanceStatisticsComponent,
    DatagridSyncfutionComponent,
    PmsInformationComponent,
    PmsCompetencyComponent,
    PmsKpiComponent,
    PmsIdpComponent,
    EmployeeSelfServiceComponent,
    MySkillXModuleComponent,
    DashboardEvaluationComponent,
    ReportCom1Component,
    ReportCom2Component,
    ReportCom3Component,
    ReportPms1Component,
    ReportPms2Component,
    ReportPms3Component,
    ReportCompetencySummaryComponent,
    EssProfileComponent,
    ExcelReportComponent,
    PivotSyncfutionComponent,
    SettingIndividualKpiComponent,
    SettingIndividualKpiSupervisorComponent,
    JobDescriptionEmpComponent,
    MoneyInputDirective,
    CompetencyMappingComponent,
    JobFamilyComponent,
    JobGradeComponent,
    JobGradeGroupComponent,
    JobFamilyMappingComponent,
    JobFamilyMatrixComponent,
    DocumentUploadManagerComponent,
    DisciplinaryActionComponent,
    OutstandingPerformanceComponent,
    PostEvaluationTrackingComponent,
    EvaluationConfirmationComponent,
    GapTrackingComponent,
    GapTrackingSupervisorComponent,
    OnboardingProgramComponent,
    TalentSuccessorComponent,
    CareerPathComponent,
    TrainingrRoadmapComponent,
    LeadershipDevelopmentComponent,
    WorkforceComponent,
    CompensationComponent,
    SalarySurveyComponent,
    RecruitmentSelectionComponent,
    JobManagementComponent,
    WelfareRewardComponent,
    TimeAttendanceWizardComponent,
    ReviewHistoryComponent,
    CalibrateComponent
  ], imports: [
    TranslateModule,
    CommonModule,
    DashboardRoutingModule,
    NgChartsModule,
    NgApexchartsModule,
    CarouselModule,
    SharedModule,
    NgxChartsModule,
    NgSelectModule,
    FormsModule,
    NgxDaterangepickerMd.forRoot(),
    DpDatePickerModule,
    MatDatepickerModule,
    MatNativeDateModule,
    MatInputModule,
    MatFormFieldModule,
    MatIconModule,
    GridModule,
    DropDownListModule,
    RatingModule,
    MatDialogModule,
    BarRatingModule,
    PivotViewModule,
    NgxEchartsModule.forRoot({
      echarts: () => import('echarts')
    })], providers: [
      Bu1Service,
      Bu2Service,
      Bu3Service,
      Bu4Service,
      Bu5Service,
      Bu6Service,
      Bu7Service,
      PositionService,
      PLService,
      EmpGroupService,
      EmpTypeService,
      CompanyService,
      CompetencytypeService,
      CompetencytopicService,
      AssessmentService,
      CompetencycourseService,
      EmployeeService,
      EvaluationCycleService,
      SettingAssessmentService,
      JobCodeService,
      BranchService,
      FileService,
      CompetencyGroupGradeService,
      IndicatorsCoursesService,
      IdpDevelopmentService,
      GroupAssessmentService,
      GroupApproveService,
      UserService,
      PmstypeService,
      PmstopicService,
      PmsGroupAssessmentService,
      PmsGroupApproveService,
      PmsEvaluationFactorsService,
      PmsMasfromEvaluationCycleService,
      PmsGroupGradeService,
      PmsSettingAssessmentService,
      EvaluationAssessmentService,
      AppraisalService,
      EventgrpService,
      PmsEvaluationCycleService,
      PmsEvaluationAssessmentService,
      PmsWorkingTimeService,
      EvaluationIdpService,
      EmpStatusService,
      ConfigPermissionService,
      TokenService,
      FieldListService,
      CalculatedFieldService,
      ConditionalFormattingService,
      NumberFormattingService,
      ToolbarService,
      GroupingBarService,
      DrillThroughService,
      VirtualScrollService,
      LineSeriesService,
      ColumnSeriesService,
      CategoryService,
      LegendService,
      TooltipService,
      ResizeService,
      SortService,
      PageService,
      FilterService,
      {
        provide: HTTP_INTERCEPTORS,
        useClass: HttpRequestInterceptor,
        multi: true,
      },
      { provide: DateAdapter, useClass: CustomDateAdapter },
      { provide: MAT_DATE_FORMATS, useValue: MY_DATE_FORMATS },
      provideHttpClient(withInterceptorsFromDi())
    ]
})
export class DashboardModule { }
