import { HttpClient, HttpHeaders } from '@angular/common/http';
import { Injectable } from '@angular/core';
import { Observable } from 'rxjs';
import { environment } from 'src/environments/environment';
import { AlertModel } from '../model/alert.model';
import { PmsMasfromEvaluationModel } from '../model/pms-masfrom-evaluation.model';

@Injectable({
  providedIn: 'root'
})
export class PmsMasfromEvaluationCycleService {
  api = "/pms-masfrom-evaluation"
  urlApi = environment.baseUrl + this.api
  constructor(private http: HttpClient) {
  }
  getList(): Observable<PmsMasfromEvaluationModel[]> {
    return this.http.get<PmsMasfromEvaluationModel[]>(this.urlApi + "/lists")
  }
  getById(pmsEvaluationRoundId: string): Observable<PmsMasfromEvaluationModel> {
    return this.http.get<PmsMasfromEvaluationModel>(this.urlApi + "/" + pmsEvaluationRoundId)
  }
  post(body: PmsMasfromEvaluationModel): Observable<AlertModel> {
    return this.http.post<AlertModel>(this.urlApi, body)
  }
  delete(body: PmsMasfromEvaluationModel | PmsMasfromEvaluationModel[]): Observable<AlertModel> {
    const options = {
      headers: new HttpHeaders({
        "Content-Type": "application/json",
      }),
      body: body
    };
    return this.http.delete<AlertModel>(this.urlApi, options)
  }

  getApsassessy(evaluationRoundId: string, apsassessy: string): Observable<any> {
    return this.http.get<any>(this.urlApi + "/" + evaluationRoundId + "/" + apsassessy)
  }
  getApsassessyMini(evaluationRoundId: string, apsassessy: string): Observable<any[]> {
    return this.http.get<any[]>(this.urlApi + "/mini/" + evaluationRoundId + "/" + apsassessy)
  }
  postList(body: any): Observable<AlertModel> {
    return this.http.post<AlertModel>(this.urlApi + "/create-list", body)
  }
  getIndicators(plId: string): Observable<any[]> {
    return this.http.get<any[]>(this.urlApi + "/indicators/list/" + plId)
  }
  postCreateForm(body: PmsMasfromEvaluationModel): Observable<AlertModel> {
        return this.http.post<AlertModel>(this.urlApi+'/create-form', body)
      }
}
