import { HttpClient, HttpHeaders } from '@angular/common/http';
import { Injectable } from '@angular/core';
import { Observable } from 'rxjs';
import { environment } from 'src/environments/environment';
import { AlertModel } from '../model/alert.model';
import { PmsGroupGradeModel } from '../model/pms-group-grade.model';
import { CompetencyGradeModel } from '../model/competency-grades.model';
@Injectable({
  providedIn: 'root'
})
export class PmsGroupGradeService {
  api = "/pms-group-grade"
  urlApi = environment.baseUrl + this.api
  constructor(private http: HttpClient) {
  }
  getById(plId: string): Observable<PmsGroupGradeModel> {
    return this.http.get<PmsGroupGradeModel>(this.urlApi + "/" + plId)
  }
  getList(): Observable<PmsGroupGradeModel[]> {
    return this.http.get<PmsGroupGradeModel[]>(this.urlApi + "/lists")
  }
  getGradeList(): Observable<CompetencyGradeModel[]> {
    return this.http.get<CompetencyGradeModel[]>(this.urlApi + "/grade/lists")
  }
  post(body: PmsGroupGradeModel): Observable<AlertModel> {
    return this.http.post<AlertModel>(this.urlApi, body)
  }
  delete(body: PmsGroupGradeModel | PmsGroupGradeModel[]): Observable<AlertModel> {
    const options = {
      headers: new HttpHeaders({
        "Content-Type": "application/json",
      }),
      body: body
    };
    return this.http.delete<AlertModel>(this.urlApi, options)
  }
}