import { HttpClient, HttpHeaders } from '@angular/common/http';
import { Injectable } from '@angular/core';
import { Observable } from 'rxjs';
import { environment } from 'src/environments/environment';
import { PLModel } from '../model/pl.model';
import { AlertModel } from '../model/alert.model';
@Injectable({
  providedIn: 'root'
})
export class PLService {
  api = "/pl"
  urlApi = environment.baseUrl + this.api
  constructor(private http: HttpClient) {
  }
  getById(plId: string): Observable<PLModel> {
    return this.http.get<PLModel>(this.urlApi + "/" + plId)
  }
  getList(): Observable<PLModel[]> {
    return this.http.get<PLModel[]>(this.urlApi + "/lists")
  }
  post(body: PLModel): Observable<AlertModel> {
    return this.http.post<AlertModel>(this.urlApi, body)
  }
  delete(body: PLModel | PLModel[]): Observable<AlertModel> {
    const options = {
      headers: new HttpHeaders({
        "Content-Type": "application/json",
      }),
      body: body
    };
    return this.http.delete<AlertModel>(this.urlApi, options)
  }
}