import { HttpClient, HttpHeaders } from '@angular/common/http';
import { Injectable } from '@angular/core';
import { Observable } from 'rxjs';
import { environment } from 'src/environments/environment';
import { AlertModel } from '../model/alert.model';
import { JobcodeModel } from '../model/jobcode.model';
import { JobCodeModel } from '../model/job-code.model';
@Injectable({
  providedIn: 'root'
})
export class JobcodeService {
  api = "/jobcode"
  urlApi = environment.baseUrl + this.api
  constructor(private http: HttpClient) {
  }
  getEmp(): Observable<JobCodeModel> {
    return this.http.get<JobCodeModel>(this.urlApi + "/emp")
  }
  getById(plId: string): Observable<JobcodeModel> {
    return this.http.get<JobcodeModel>(this.urlApi + "/" + plId)
  }
  getList(): Observable<JobcodeModel[]> {
    return this.http.get<JobcodeModel[]>(this.urlApi + "/lists")
  }
  getGroupAssessmentList(): Observable<JobcodeModel[]> {
    return this.http.get<JobcodeModel[]>(this.urlApi + "/group-assessment/lists")
  }
  post(body: JobcodeModel): Observable<AlertModel> {
    return this.http.post<AlertModel>(this.urlApi, body)
  }
  delete(body: JobcodeModel | JobcodeModel[]): Observable<AlertModel> {
    const options = {
      headers: new HttpHeaders({
        "Content-Type": "application/json",
      }),
      body: body
    };
    return this.http.delete<AlertModel>(this.urlApi, options)
  }
}