import { EmeventgrpModel, MyEmeventgrpModel } from "./emeventgrp.model"

export interface PmsWorkingTimeModel {
    pmsWorkingTimeId: string
    companyId: string
    meventgrpId: string
    tdesc: string
    edesc: string
    weight: number
    detailUnit: string
    performanceTargets: string
    targetADetail: string
    conditionAMin: number
    conditionAMax: number
    targetBDetail: string
    conditionBMin: number
    conditionBMax: number
    targetCDetail: string
    conditionCMin: number
    conditionCMax: number
    targetDDetail: string
    conditionDMin: number
    conditionDMax: number
    targetEDetail: string
    conditionEMin: number
    conditionEMax: number
    emeventgrp: EmeventgrpModel[]
}

export class MyPmsWorkingTimeModel implements PmsWorkingTimeModel {
    pmsWorkingTimeId: string
    companyId: string
    meventgrpId: string
    tdesc: string
    edesc: string
    weight: number
    detailUnit: string
    performanceTargets: string
    targetADetail: string
    conditionAMin: number
    conditionAMax: number
    targetBDetail: string
    conditionBMin: number
    conditionBMax: number
    targetCDetail: string
    conditionCMin: number
    conditionCMax: number
    targetDDetail: string
    conditionDMin: number
    conditionDMax: number
    targetEDetail: string
    conditionEMin: number
    conditionEMax: number
    emeventgrp: EmeventgrpModel[]
    constructor(data?: Partial<PmsWorkingTimeModel>) {
        this.pmsWorkingTimeId = data?.pmsWorkingTimeId || ""
        this.companyId = data?.companyId || ""
        this.meventgrpId = data?.meventgrpId || ""
        this.tdesc = data?.tdesc || ""
        this.edesc = data?.edesc || ""
        this.weight = data?.weight ?? 0
        this.detailUnit = data?.detailUnit || ""
        this.performanceTargets = data?.performanceTargets || ""
        this.targetADetail = data?.targetADetail || ""
        this.conditionAMin = data?.conditionAMin ?? 0
        this.conditionAMax = data?.conditionAMax ?? 0
        this.targetBDetail = data?.targetBDetail || ""
        this.conditionBMin = data?.conditionBMin ?? 0
        this.conditionBMax = data?.conditionBMax ?? 0
        this.targetCDetail = data?.targetCDetail || ""
        this.conditionCMin = data?.conditionCMin ?? 0
        this.conditionCMax = data?.conditionCMax ?? 0
        this.targetDDetail = data?.targetDDetail || ""
        this.conditionDMin = data?.conditionDMin ?? 0
        this.conditionDMax = data?.conditionDMax ?? 0
        this.targetEDetail = data?.targetEDetail || ""
        this.conditionEMin = data?.conditionEMin ?? 0
        this.conditionEMax = data?.conditionEMax ?? 0
        this.emeventgrp = data?.emeventgrp?.map(x => new MyEmeventgrpModel(x)) || []
    }
}

