import { ChangeDetectorRef, Component, EventEmitter, Input, Output } from '@angular/core';
import { DomSanitizer, SafeHtml } from '@angular/platform-browser';
import { TranslateService } from '@ngx-translate/core';
import { DocumentManagerModel, MyDocumentManagerModel } from 'src/app/shared/model/document-manager.model';
import { DocumentManagerService } from 'src/app/shared/services/documents.service';
import { FileService } from 'src/app/shared/services/file.service';
import Swal from 'sweetalert2';
interface SubModule {
  title: SafeHtml;
  route?: string;
  file?: string;
}

@Component({
  selector: 'app-talent-successor',
  templateUrl: './talent-successor.component.html',
  styleUrls: ['./talent-successor.component.scss']
})
export class TalentSuccessorComponent {

  generalPages = [
    { text: "เลือก Target Position", description: "" },
    { text: "เกณฑ์และปัจจัยในการประเมิน Talent", description: "" },
    { text: "สรุปรายชื่อคนที่เข้าเกณฑ์เป็น Talent", description: "" },
    { text: "สรุปรายชื่อคนที่เข้าเกณฑ์เป็น Successor", description: "" },
    { text: "ผลประเมินศักยภาพ (9 box grid)", description: "" },
    { text: "หลักสูตรภาคบังคับ", description: "" },
    { text: "หลักสูตรพัฒนา", description: "" },
    { text: "Individual Development Plan (IDP)", description: "" },
    { text: "ผลประเมินประจำปี", description: "" },
    { text: "แบบฟอร์มการประเมิน", description: "" },
    { text: "เชื่อมโยงกับระบบ Promotion", description: "" },
  ];

  performancePages = [
    [{ text: "ข้อมูลผลงานย้อนหลัง", description: "" },
    { text: "ข้อมูลผลงานที่โดดเด่น", description: "" },
    { text: "ข้อมูลผลประเมิน Accountability", description: "" }],
    [{ text: "ข้อมูลประสบการณ์ภายนอก", description: "" },
    { text: "อื่นๆ", description: "" }]
  ];

  competencyPages = [
    [{ text: "ข้อมูลผลประเมินตำแหน่งงานในอนาคต", description: "" },
    { text: "ข้อมูลผลประเมินความเป็นผู้นำ", description: "" },
    { text: "ข้อมูลผลประเมินพฤติกรรมและทัศนคติ", description: "" }],
    [{ text: "ข้อมูลผลประเมิน ภาษาอังกฤษ / จีน / ญี่ปุ่น", description: "" },
    { text: "ข้อมูลผลประเมิน Competency", description: "" }]
  ];

  documentManager: { loading: boolean, dataList: DocumentManagerModel[] } = { loading: false, dataList: [] }

  constructor(private sanitizer: DomSanitizer,
    private fileService: FileService,
    private cdr: ChangeDetectorRef,
    private translateService: TranslateService,
    private documentManagerService: DocumentManagerService
  ) {

  }

  ngOnInit(): void {
    this.getDocumentManagerList()
  }

  getDocumentManagerList() {
    this.documentManager.loading = true
    this.documentManagerService.getList().subscribe({
      next: response => {
        this.documentManager.dataList = response.map(x => {
          return new MyDocumentManagerModel(x)
        })
        this.documentManager.loading = false
        this.cdr.detectChanges();
      }, error: error => {
        this.documentManager.loading = false
        console.error('Error fetching employee types:', error);
        this.cdr.detectChanges()
      }
    })
  }
  openReport(file: string) {
    const url = 'assets/reports/' + file;
    window.open(url, '_blank');
  }

  downloadFile(fileName: string) {
    this.fileService.downloadFiles(fileName).subscribe({
      next: response => {
        const url = window.URL.createObjectURL(response);
        const a = document.createElement("a");
        a.href = url;
        a.download = fileName;
        document.body.appendChild(a);
        a.click();
        document.body.removeChild(a);
        window.URL.revokeObjectURL(url);
        this.cdr.detectChanges()
      }, error: error => {
        this.showAlert(error.message, 'error')
        this.cdr.detectChanges()
      }
    })
  }

  showAlert(text: string, type: 'success' | 'error') {
    Swal.fire({
      icon: type,
      title: 'แจ้งเตือน',
      text: text,
      showCancelButton: false,
      confirmButtonText: 'ยืนยัน',
    })
  }


  translateText(th?: string, en?: string) {
    return this.translateService.getCurrentLang() == 'th' ? (th || '') : (en || '')
  }


}


