import { ViewportScroller } from '@angular/common';
import { ChangeDetectorRef, Component, ViewChild } from '@angular/core';
import { MatDialog } from '@angular/material/dialog';
import { Router } from '@angular/router';
import { TranslateService } from '@ngx-translate/core';
import { ColumnModel } from '@syncfusion/ej2-grids';
import { ToastrService } from 'ngx-toastr';
import { EmployeeModel, MyEmployeeModel } from 'src/app/shared/model/employee.model';
import { JobCodeModel, MyJobCodeModel } from 'src/app/shared/model/job-code.model';
import { MyStatusModel, StatusModel } from 'src/app/shared/model/status.model';
import { EmpStatusService } from 'src/app/shared/services/emp-status.service';
import { EmployeeService } from 'src/app/shared/services/employee.service';
import { EventgrpService } from 'src/app/shared/services/eventgrp.service';
import { FileService } from 'src/app/shared/services/file.service';
import { JobcodeService } from 'src/app/shared/services/jobcode.service';
import { PmsWorkingTimeService } from 'src/app/shared/services/pms-working-time.service';
import Swal from 'sweetalert2';
export interface BiModel {
  name: string,
  tools: string[],
  degree: string
}

@Component({
  selector: 'app-disciplinary-action',
  templateUrl: './disciplinary-action.component.html',
  styleUrls: ['./disciplinary-action.component.scss']
})
export class DisciplinaryActionComponent {
  currentPage = 1
  empDetail: { loading: boolean, data: JobCodeModel } = { loading: false, data: new MyJobCodeModel({}) }

  columns: ColumnModel[] = [
    {
      field: "picture",
      headerText: "",
      type: "string",
    }, {
      field: "employeeId",
      headerText: "EmployeeCode",
      type: "string",
      isPrimaryKey: true,
    },
    {
      field: "fname",
      headerText: "FirstName",
      type: "string"
    },
    {
      field: "lname",
      headerText: "LastName",
      type: "string"
    },
    {
      field: "position.tdesc",
      headerText: "Position",
      type: "string"
    }]
  searchSettings = {
    fields: ['employeeId', 'fname', 'lname', 'position.tdesc'],
    operator: 'contains',
    ignoreCase: false
  }
  search = ''
  employee: { loading: boolean, select: EmployeeModel, list: EmployeeModel[] } = { loading: false, select: new MyEmployeeModel(), list: [] }
  @ViewChild('employeeDialog') employeeDialog: any
  employeeDialogRef: any

  dateSelectIso = {
    dateIncident: '',
    dateEffective: ''
  }
  dateSelect = {
    dateIncident: '',
    dateEffective: ''
  }
  constructor(
    private toastr: ToastrService,
    private cdr: ChangeDetectorRef,
    private dialog: MatDialog,
    private fileService: FileService,
    private eventgrpService: EventgrpService,
    private jobcode: JobcodeService,
    private employeeService: EmployeeService,
    private translateService: TranslateService,
    private router: Router
  ) {
    this.translateService.onLangChange.subscribe((event) => {
    });
  }
  ngOnInit(): void {
    this.getEmployeeList()
  }
  getEmployeeList() {
    this.employee.loading = true
    this.employeeService.getSubordinatesList().subscribe({
      next: response => {
        this.employee.list = response.map((x: any) => new MyEmployeeModel(x))
        this.employee.loading = false
        this.cdr.detectChanges()
      }, error: error => {
        this.employee.loading = false
        this.cdr.detectChanges()
      }
    })
  }
  selectEmployee(data?: EmployeeModel) {
    this.employee.select = new MyEmployeeModel(data)
  }
  openEmployeeDialog() {
    this.employeeDialogRef = this.dialog.open(this.employeeDialog, {
      width: '800px',
    })
  }
  closeEmployeeDialog() {
    this.employeeDialogRef.close()
  }

  toISODate(dateInput?: string | null): string {
    if (!dateInput) return "";
    const parsedDate = new Date(dateInput);
    return isNaN(parsedDate.getTime()) ? new Date().toISOString() : parsedDate.toISOString();
  }
  changeDate(target: { [key: string]: any }, field: string, dateIso: string) {
    target[field] = this.toYYYYMMDD(dateIso)
  }
  toYYYYMMDD(dateInput?: string | null): string {
    if (!dateInput) return "";
    const parsedDate = new Date(dateInput);
    const options: Intl.DateTimeFormatOptions = {
      year: 'numeric',
      month: '2-digit',
      day: '2-digit',
    };
    const formattedDate = parsedDate.toLocaleDateString('en-GB', options);
    const [day, month, year] = formattedDate.split('/');
    return `${year}-${month}-${day}`;
  }

  save() {
    Swal.fire({
      icon: 'question',
      title: 'แจ้งเตือน',
      text: 'ยืนยันการบันทึกข้อมูลหรือไม่',
      showCancelButton: true,
      confirmButtonText: 'บันทึกข้อมูล',
      cancelButtonText: 'ย้อนกลับ',
      reverseButtons: true,
    }).then((result) => {
      if (result.isConfirmed) {
        this.showAlert('บันทึกข้อมูลสำเร็จ', 'success')
        this.closeEmployeeDialog();
      }
    });
  }

  showAlert(text: string, type: 'success' | 'error') {
    Swal.fire({
      title: 'แจ้งเตือน',
      text: text,
      icon: type,
      confirmButtonText: 'ตกลง',
    });
  }

  back() {
    this.router.navigate(['/ess/employee-self-service']);
  }
}