import { Component, EventEmitter, Input, Output, OnInit, ChangeDetectorRef } from '@angular/core';
import { ToastrService } from 'ngx-toastr';
import { CompetencyGradeModel } from 'src/app/shared/model/competency-grades.model';
import { MyCompetencyGroupGradeModel } from 'src/app/shared/model/competency-group-grade.model';
import { CompetencyGroupGradeService } from 'src/app/shared/services/competency-group-grade.service';
export interface DataModel {
  check: boolean
  code: string
  tdesc: string
  edesc: string
  competencyGrades: CompetencyGradeModel[]
  companyId: string
}

@Component({
  selector: 'app-group-grade',
  templateUrl: './group-grade.component.html',
  styleUrls: ['./group-grade.component.scss']
})
export class GroupGradeComponent implements OnInit {
  @Output() sendBackTab: EventEmitter<undefined> = new EventEmitter<undefined>();
  @Input() typeTab: 'add' | 'edit' = 'add'
  @Input() dataSelect: DataModel = { check: false, code: '', tdesc: '', edesc: '', competencyGrades: [], companyId: '' }
  dataOriginal: DataModel = { check: false, code: '', tdesc: '', edesc: '', competencyGrades: [], companyId: '' }
  @Output() sendDataList: EventEmitter<DataModel[]> = new EventEmitter<DataModel[]>();
  currentTab = 1
  constructor(private toastr: ToastrService,
    private competencyGroupGradeService: CompetencyGroupGradeService,
    private cdr: ChangeDetectorRef) { }
  ngOnInit(): void {
    this.dataOriginal = JSON.parse(JSON.stringify(this.dataSelect || { check: false, code: '', tdesc: '', edesc: '', competencyGrades: [], companyId: '' }))
  }
  clear() {
    if (this.typeTab == 'add') {
      this.dataSelect = { check: false, code: '', tdesc: '', edesc: '', competencyGrades: [], companyId: '' }
      this.cdr.detectChanges()
    } else if (this.typeTab == 'edit') {
      this.dataSelect = { check: false, code: this.dataOriginal.code, tdesc: '', edesc: '', competencyGrades: [], companyId: '' }
      this.cdr.detectChanges()
    }
  }
  backTab() {
    this.sendBackTab.emit();
  }
  postCompetencyGroupGrade() {
    this.competencyGroupGradeService.post(new MyCompetencyGroupGradeModel({ groupGradeId: this.dataSelect.code, tdesc: this.dataSelect.tdesc, edesc: this.dataSelect.edesc, competencyGrades: this.dataSelect.competencyGrades, companyId: this.dataSelect.companyId })).subscribe({
      next: response => {
        if (response.success) {
          this.showAlert(response.message, 'success')
          this.getCompetencyGroupGradeList()
        } else {
          this.showAlert(response.message, 'error')
        }
      }, error: error => {
        this.showAlert(error.message, 'error')
      }
    })
  }
  getCompetencyGroupGradeList() {
    this.competencyGroupGradeService.getList().subscribe({
      next: response => {
        this.sendDataList.emit(response.map(x => ({ check: false, code: x.groupGradeId, tdesc: x.tdesc, edesc: x.edesc, competencyGrades: x.competencyGrades, companyId: this.dataSelect.companyId })))
        this.cdr.detectChanges()
      }
    })
  }
  showAlert(text: string, type: 'success' | 'error') {
    this.toastr[type](text, 'แจ้งเตือน', {
      timeOut: 3000,
      positionClass: 'toast-top-right',
    });
  }


}
