import { HttpClient, HttpHeaders } from '@angular/common/http';
import { Injectable } from '@angular/core';
import { Observable } from 'rxjs';
import { environment } from 'src/environments/environment';
import { CompetencytopicModel } from '../model/competencytopic.model';
import { AlertModel } from '../model/alert.model';
@Injectable({
  providedIn: 'root'
})
export class CompetencytopicService {
  api = "/competencytopic"
  urlApi = environment.baseUrl + this.api
  constructor(private http: HttpClient) {
  }
  getById(competencyTopicId: string): Observable<CompetencytopicModel> {
    return this.http.get<CompetencytopicModel>(this.urlApi + "/" + competencyTopicId)
  }
  getList(): Observable<CompetencytopicModel[]> {
    return this.http.get<CompetencytopicModel[]>(this.urlApi + "/lists")
  }
  post(body: CompetencytopicModel): Observable<AlertModel> {
    return this.http.post<AlertModel>(this.urlApi, body)
  }
  delete(body: CompetencytopicModel | CompetencytopicModel[]): Observable<AlertModel> {
    const options = {
      headers: new HttpHeaders({
        "Content-Type": "application/json",
      }),
      body: body
    };
    return this.http.delete<AlertModel>(this.urlApi, options)
  }
}