import { Component, EventEmitter, Input, Output } from '@angular/core';
type ModuleCard = { icon: string; title: string };
@Component({
  selector: 'app-my-skill-x-module',
  templateUrl: './my-skill-x-module.component.html',
  styleUrls: ['./my-skill-x-module.component.scss']
})
export class MySkillXModuleComponent {
  hrdModules: ModuleCard[] = [
    { icon: 'assets/img/logos/HRD/1.png', title: 'Performance & Competency' },
    { icon: 'assets/img/logos/HRD/2.png', title: 'On-Boarding Program' },
    { icon: 'assets/img/logos/HRD/3.png', title: 'Talent & Successor' },
    { icon: 'assets/img/logos/HRD/4.png', title: 'Career Path' },
    { icon: 'assets/img/logos/HRD/5.png', title: 'Training Roadmap' },
    { icon: 'assets/img/logos/HRD/6.png', title: 'Leadership' }
  ];

  hrmModules: ModuleCard[] = [
    { icon: 'assets/img/logos/HDM/1.png', title: 'Workforce' },
    { icon: 'assets/img/logos/HDM/2.png', title: 'Compensation' },
    { icon: 'assets/img/logos/HDM/3.png', title: 'Salary Survey' },
    { icon: 'assets/img/logos/HDM/4.png', title: 'Recruit & Selection' },
    { icon: 'assets/img/logos/HDM/5.png', title: 'JD & Org Chart' },
    { icon: 'assets/img/logos/HDM/6.png', title: 'Welfare & Reward' }
  ];

  goToWebsite(web: string) {
    window.open(web, '_blank');
  }
}
