import { HttpClient, HttpHeaders } from '@angular/common/http';
import { Injectable } from '@angular/core';
import { Observable } from 'rxjs';
import { environment } from 'src/environments/environment';
import { AlertModel } from '../model/alert.model';
import { PmstopicModel } from '../model/pmstopic.model';
@Injectable({
  providedIn: 'root'
})
export class PmstopicService {
  api = "/pmstopic"
  urlApi = environment.baseUrl + this.api
  constructor(private http: HttpClient) {
  }
  getById(pmsTopicId: string): Observable<PmstopicModel> {
    return this.http.get<PmstopicModel>(this.urlApi + "/" + pmsTopicId)
  }
  getList(): Observable<PmstopicModel[]> {
    return this.http.get<PmstopicModel[]>(this.urlApi + "/lists")
  }
  post(body: PmstopicModel): Observable<AlertModel> {
    return this.http.post<AlertModel>(this.urlApi, body)
  }
  delete(body: PmstopicModel | PmstopicModel[]): Observable<AlertModel> {
    const options = {
      headers: new HttpHeaders({
        "Content-Type": "application/json",
      }),
      body: body
    };
    return this.http.delete<AlertModel>(this.urlApi, options)
  }
}