import { HttpClient, HttpHeaders } from '@angular/common/http';
import { Injectable } from '@angular/core';
import { Observable } from 'rxjs';
import { environment } from 'src/environments/environment';
import { AlertModel } from '../model/alert.model';
import { ConfigPermissionModel } from '../model/config-permission.model';
@Injectable({
  providedIn: 'root'
})
export class ConfigPermissionService {
  api = "/config"
  urlApi = environment.baseUrl + this.api
  constructor(private http: HttpClient) {
  }
  getByUserLevel(userLevel: string): Observable<ConfigPermissionModel> {
    return this.http.get<ConfigPermissionModel>(this.urlApi + "/permission-view-screen/" + userLevel)
  }
  getList(): Observable<ConfigPermissionModel[]> {
    return this.http.get<ConfigPermissionModel[]>(this.urlApi + "/permission-view-screen/lists")
  }
  post(body: ConfigPermissionModel): Observable<AlertModel> {
    return this.http.post<AlertModel>(this.urlApi + '/permission-view-screen', body)
  }
  delete(body: ConfigPermissionModel[]): Observable<AlertModel> {
    const options = {
      headers: new HttpHeaders({
        "Content-Type": "application/json",
      }),
      body: body
    };
    return this.http.delete<AlertModel>(this.urlApi + "/permission-view-screen", options)
  }
}