import { HttpClient, HttpHeaders } from '@angular/common/http';
import { Injectable } from '@angular/core';
import { Observable } from 'rxjs';
import { environment } from 'src/environments/environment';
import { CompetencytypeModel } from '../model/competencytype.model';
import { AlertModel } from '../model/alert.model';
import { EmpGroupModel } from '../model/emp-group.model';
@Injectable({
  providedIn: 'root'
})
export class CompetencytypeService {
  api = "/competencytype"
  urlApi = environment.baseUrl + this.api
  constructor(private http: HttpClient) {
  }
  getById(competencyTypeId: string): Observable<CompetencytypeModel> {
    return this.http.get<CompetencytypeModel>(this.urlApi + "/" + competencyTypeId)
  }
  getList(): Observable<CompetencytypeModel[]> {
    return this.http.get<CompetencytypeModel[]>(this.urlApi + "/lists")
  }
  post(body: CompetencytypeModel ): Observable<AlertModel> {
    return this.http.post<AlertModel>(this.urlApi, body)
  }
  delete(body: CompetencytypeModel | CompetencytypeModel[]): Observable<AlertModel> {
    const options = {
      headers: new HttpHeaders({
        "Content-Type": "application/json",
      }),
      body: body
    };
    return this.http.delete<AlertModel>(this.urlApi, options)
  }
}