import { HttpClient } from '@angular/common/http';
import { Injectable } from '@angular/core';
import { Observable } from 'rxjs';
import { environment } from 'src/environments/environment';
import { AlertModel } from '../model/alert.model';
import { AppraisalCompentencyModel, AppraisalCompentencyModel2 } from '../model/appraisal-competency.model';
import { AppraisalSubordinateModel } from '../model/appraisal-subordinate.model';
import { AppraisalPmsFormModel } from '../model/appraisal-pms-form.model';
import { AppraisalPmsModel } from '../model/appraisal-pms.model';
import { CompetencyModel } from '../model/competency.model';
@Injectable({
  providedIn: 'root'
})
export class CompetencySummaryService {
  api = "/competency-summary"
  urlApi = environment.baseUrl + this.api
  constructor(private http: HttpClient) {
  }
  getCompentencySummaryList(): Observable<any[]> {
    return this.http.get<any[]>(this.urlApi + "/lists")
  }
}