import { HttpClient, HttpHeaders } from '@angular/common/http';
import { Injectable } from '@angular/core';
import { Observable } from 'rxjs';
import { environment } from 'src/environments/environment';
import { Bu1Model } from '../model/bu1.model';
import { AlertModel } from '../model/alert.model';
@Injectable({
  providedIn: 'root'
})
export class Bu1Service {
  api = "/bu1"
  urlApi = environment.baseUrl + this.api
  constructor(private http: HttpClient) {
  }
  getList(): Observable<Bu1Model[]> {
    return this.http.get<Bu1Model[]>(this.urlApi + "/lists")
  }
  getById(bu1id: string): Observable<Bu1Model> {
    return this.http.get<Bu1Model>(this.urlApi + "/" + bu1id)
  }
  post(body: Bu1Model): Observable<AlertModel> {
    return this.http.post<AlertModel>(this.urlApi, body)
  }
  delete(body: Bu1Model[]): Observable<AlertModel> {
    const options = {
      headers: new HttpHeaders({
        "Content-Type": "application/json",
      }),
      body: body
    };
    return this.http.delete<AlertModel>(this.urlApi, options)
  }
}
