export interface ConfigPermissionModel {
    userLevel: string
    tdesc: string
    edesc: string
    companyId: string
    menuBody: MenuBodyModel[]
}


export class MyConfigPermissionModel implements ConfigPermissionModel {
    userLevel: string
    tdesc: string
    edesc: string
    companyId: string
    menuBody: MenuBodyModel[]
    constructor(data?: Partial<ConfigPermissionModel>) {
        this.userLevel = data?.userLevel || ""
        this.tdesc = data?.tdesc || ""
        this.edesc = data?.edesc || ""
        this.companyId = data?.companyId || ""
        this.menuBody = data?.menuBody?.map(x => new MyMenuBodyModel(x)) || []
    }
}

export interface MenuBodyModel {
    path: string
    show: boolean
    type: string
    title: string
    active: boolean
    children: {
        path: string
        show: boolean
        type: string
        title: string
        id: string
    }[]
    selected: boolean
    headTitle?: string;
    headTitle2?: string;
    icon?: string;
    badgeValue?: string;
    badgeClass?: string;
    bookmark?: boolean;
    children2?: {
        path: string
        show: boolean
        type: string
        title: string
    }[];
    Menusub?: boolean;
    target?: boolean;
    id: string
}


export class MyMenuBodyModel implements MenuBodyModel {
    path: string
    show: boolean
    type: string
    title: string
    active: boolean
    children: {
        path: string
        show: boolean
        type: string
        title: string
        id: string
    }[]
    selected: boolean
    headTitle?: string;
    headTitle2?: string;
    icon?: string;
    badgeValue?: string;
    badgeClass?: string;
    bookmark?: boolean;
    children2?: {
        path: string
        show: boolean
        type: string
        title: string
        id: string
    }[];
    Menusub?: boolean;
    target?: boolean;
    id: string
    constructor(data?: Partial<MenuBodyModel>) {
        this.path = data?.path || ''
        this.show = data?.show ?? false
        this.type = data?.type || ""
        this.title = data?.title || ""
        this.active = data?.active ?? false
        this.children = data?.children?.map(x => ({
            path: x.path || '',
            show: x.show ?? false,
            type: x.type || '',
            title: x.title || '',
            id: x.id || ''
        })) || []
        this.selected = data?.selected ?? false
        this.id = data?.id || ''
        // this.headTitle = data?.headTitle || ""
        // this.headTitle2 = data?.headTitle2 || ""
        // this.icon = data?.icon || ""
        // this.badgeValue = data?.badgeValue || ""
        // this.badgeClass = data?.badgeClass || ""
        // this.bookmark = data?.bookmark ?? false
        // this.children2 = data?.children2?.map(x => ({
        //     path: x.path || '',
        //     show: x.show ?? false,
        //     type: x.type || '',
        //     title: x.title || ''
        // })) || []
        // this.Menusub = data?.Menusub ?? false
        // this.target = data?.target ?? false
    }
}

